function [Fx,ad2U] = TestShearQuasiStatic(ad2Mass, Fz, UxMax, PLOT, VideoName)
if nargin < 4, PLOT = 0; end
if nargin < 5, VideoName = []; end
global as1Springs
XY = ad2Mass(:,1:2);
if PLOT ~= 0 && ~isempty(VideoName)
    FileName = VideoName;
    %% Create the object
    FPS = round(10); % Frames per second
    writerObj = VideoWriter(FileName,'MPEG-4');
    writerObj.Quality = 100;
    writerObj.FrameRate = FPS; % frames per second
    open(writerObj); 
    figure(1);
    pause;
end

nMass = size(ad2Mass,1);
%% Solve
nZ = 0; nX = 100;
Fz = [Fz Fz*ones(1,nX+1)];
Fx = zeros(size(Fz));
Ux = [zeros(1,nZ+1) (0:1:nX)/nX*UxMax];
ad2U = zeros(2*nMass,length(Fx));
ad1U = zeros(2*nMass,1);
Fext = zeros(2*nMass,1);
Uext = zeros(2*nMass,1);
CONV = 1;
fprintf(1, '\n');
fprintf(1, 'Loop on applied forces (%d steps)\n', length(Ux));
fprintf(1, '[0%%                                            100%%]\n');
fprintf(1, '[');
STARS = zeros(50,1); star = 0;
for iFx = 1: 1: length(Ux)
    if mod(iFx+1,round(length(Ux)/50))==0
        star = star + 1;
        if star <= 50 && STARS(star) == 0
            fprintf(1, '*');
            STARS(star) = 1;
        end
    end
    Fext(end) = -Fz(iFx);
    Uext(:) = 0;
    Uext(end-3) = Ux(iFx);
    if CONV == 1
        [ad2U(:,iFx), CONV] = Static_NL(@(ad1u)ForcesAndMatrices(ad1u,ad2Mass),ad1U, Fext, Uext);
%         if CONV == 1
            output = ForcesAndMatrices(ad2U(:,iFx),ad2Mass);
            Fint = output.Fint;
            Fx(iFx) = -Fint(end-3);
%         else
%             if iFx ~= 1
%                 ad2U(:,iFx) = ad2U(:,iFx-1);
%                 Fx(iFx) = Fx(iFx-1);
%             end
%         end
        CONV = 1;
    else
        CONV = 1;
%         ad2U(:,iFx) = ad2U(:,iFx-1);
%         Fx(iFx+1:end) = Fx(iFx);
    end
    if PLOT
        ad1X = ad2U(1:2:end,iFx);
        ad1Y = ad2U(2:2:end,iFx);
        plot(XY(:,1)+ad1X,XY(:,2)+ad1Y,'ob');
        xlim([min(XY(:,1))-0.1 max(XY(:,1))+0.1]);
        ylim([min(XY(:,2))-0.1 max(XY(:,2))+0.1]);
        title(['Ux = ' num2str(Ux(iFx)) ', Fx = ' num2str(Fx(iFx)) ', Fz = ' num2str(Fz(iFx))]);
        drawnow;
        if ~isempty(VideoName)
            writeVideo(writerObj,getframe(gcf));
        end
    end
end
if PLOT ~= 0 && ~isempty(VideoName)
    close(writerObj);
end
for iStar = 1: 1: length(STARS)
    if STARS(iStar) == 0
        STARS(iStar) = 1;
        fprintf(1, '*');
    end
end
fprintf(1, ']\n');
ad2U = ad2U.';
end

%% Time integrator
function [U, CONV] = Static_NL(func, up, Fext, Uext)
global as1Springs
Arclength = 1e-3;
% Time sample
as1SpringsTemp = as1Springs;
kIter = 0;
U = up;
CONV = 1;
while 1
    kIter = kIter + 1;
    if kIter > 100
        fprintf(1, 'WARNING: Solutions did not converge ...\n');
        as1Springs = as1SpringsTemp;
        CONV = 0;
        break;
    end
    %Reset non-linear connections to values at beginning of iteration
    as1Springs = as1SpringsTemp;
    output = func(U);
    K = output.K;
    Fint = output.Fint;
    dof = output.dof;
    Presc = 1:1:length(Fext);
    Presc(dof) = [];
    U(Presc) = Uext(Presc);
    F = Fext + Fint;
    ratio = norm(F(dof))/norm(Fext(dof));
    if norm(F(dof)) == 0, break; end
    if ratio<=1e-5, break; end
    du = K(dof,dof)\F(dof);
    NORM = max(abs(du));
    if NORM > Arclength
        du = du/NORM*Arclength;
    end
    U(dof) = U(dof)+du;
end
end

%% Integrating function
function output = ForcesAndMatrices(ad1U, ad2Mass)
% Internal forces and system matrices
[ad1Fint, ad2K] = CalculateForcesAndMatrices(ad1U,ad1U*0,ad2Mass);
dof = [ad2Mass(:,4)';ad2Mass(:,5)']; dof = find(dof(:));
output.Fint = ad1Fint;
output.K = ad2K;
output.dof = dof;
end
