function [ad1T, ad2U, ad2V, ad2A, Sdev] = ...
        TestBiAxialImplicit(ad2Mass, TopNodes, RightNodes, StressPaths, Ti, dt, PLOT, VideoName)
if nargin < 5, Ti = 1; end
if nargin < 6, dt = 0.01; end
if nargin < 7, PLOT = 0; end
if nargin < 8, VideoName = []; end
Ti = -Ti;
global TOP
global RIGHT
TOP = TopNodes;
RIGHT = RightNodes;
%% Solve ode
[ad1T, ad2U, ad2V, ad2A, Sdev] = Implicit_NL(@(t,ad1U, ad1V)ForcesAndMatrices(t,ad1U,ad1V,...
                    ad2Mass,TopNodes,RightNodes,StressPaths,Ti,...
                    sum(round(StressPaths(:,4)./StressPaths(:,5)))),...
                    Ti, dt, sum(round(StressPaths(:,4)./StressPaths(:,5))), PLOT, ...
                    ad2Mass(:,1:2),VideoName);
ad2U = ad2U.';
ad2V = ad2V.';
ad2A = ad2A.';

end

%% Time integrator
function [T, U, V, A, Sdev] = Implicit_NL(func, t0, dt, tf, PLOT, XY, VideoName)
if PLOT ~= 0 && ~isempty(VideoName)
    FileName = VideoName;
    %% Create the object
    FPS = round(1/dt/PLOT); % Frames per second
    writerObj = VideoWriter(FileName,'MPEG-4');
    writerObj.Quality = 100;
    writerObj.FrameRate = FPS; % frames per second
    open(writerObj); 
    figure(1);
    pause;
end
global TOP
global RIGHT

global as1Springs;
% Newmark parameters
gamma = 0.5;
beta  = 0.25;
a0 = 1/(beta*dt^2);
a1 = gamma/(beta*dt);
a2 = 1/(beta*dt);
a3 = 1/(2*beta)-1;
a4 = gamma/beta-1;
a5 = dt*(gamma/(2*beta)-1);

% Time sample
kT = 0;
T = t0:dt:tf; nT = length(T);
up = []; vp = [];
fprintf(1, '\n');
fprintf(1, 'Newmark loop on time steps (%d time intervals)\n', nT);
fprintf(1, '[0%%                                            100%%]\n');
fprintf(1, '[');
STARS = zeros(50,1); star = 0;
global OUTPUT
OUTPUT = 1;
kPlot = 0;
Name{1} = 'Normal';
Name{2} = 'Diagonal';
Name{3} = 'Shear';
for t = t0:dt:tf
    if mod(kT+1,round(nT/50))==0
        star = star + 1;
        if star <= 50 && STARS(star) == 0
            fprintf(1, '*');
            STARS(star) = 1;
        end
    end
    kPlot = kPlot + 1;
    % Calculate internal forces and system matrices
%     up1 = up; vp1 = vp;
%     ad2NonLinearConnection1 = ad2NonLinearConnection;
    output = func(t, up, vp);
    if kT == 0
        K = output.K;
        C = output.C;
        M = output.M;
        dof = output.dof;
        nDof = size(K,1);
        Keq = K + a1*C + a0*M;
        ad2L = chol(Keq(dof,dof), 'lower');
        ad2U = ad2L';
        OUTPUT = 0;
        uc = zeros(nDof,1);
        up = zeros(nDof,1);
        vp = zeros(nDof,1);
        ap = zeros(nDof,1);
        U = zeros(nDof,length(T));
        V = zeros(nDof,length(T));
        A = zeros(nDof,length(T));
        Sdev = zeros(length(T),1);
        lX = max(XY(:,1))-min(XY(:,1));
        lZ = max(XY(:,2))-min(XY(:,2));
    end
    Fint = output.Fint;
    Fext = output.Fext;
    F = Fext + Fint;

    %% Calculate current step
    uc(dof) = ad2U\(ad2L\(...
                    F(dof) + C(dof,:)*(a1*up+(a4+1)*vp+a5*ap) + ...
                             M(dof,:)*(a0*up+    a2*vp+a3*ap) + ...
                             K(dof,:)*up));
    vc = a1*(uc-up) - a4*vp - a5*ap;
    ac = a0*(uc-up) - a2*vp - a3*ap;
    
    % Store variables
    kT = kT + 1;
    U(:,kT) = uc;
    V(:,kT) = vc;
    A(:,kT) = ac;
    Sdev(kT) = abs(sum(Fext(2*TOP)))/lX-abs(sum(Fext(2*RIGHT-1)))/lZ;
    
    % Udate variables
    up = uc;
    vp = vc;
    ap = ac;
    if PLOT && isempty(VideoName)
        ad1X = uc(1:2:end);
        ad1Y = uc(2:2:end);
        plot(XY(:,1)+ad1X,XY(:,2)+ad1Y,'ob');
        xlim([min(XY(:,1))-0.1 max(XY(:,1))+0.1]);
        ylim([min(XY(:,2))-0.1 max(XY(:,2))+0.1]);
        title(['T = ' num2str(t) '; Force = ' num2str(sum(Fext))]);
        drawnow;
    end
    if PLOT ~= 0 && PLOT == kPlot && ~isempty(VideoName)
        for iType = 1: 1: length(Name)
            subplot(1,length(Name),iType);
            kPlot = 0;
            ad1X = uc(1:2:end);
            ad1Y = uc(2:2:end);
            plot(XY(:,1)+ad1X,XY(:,2)+ad1Y,'ob'); hold on;
            for iSpring = 1: 1: length(as1Springs)
                Spring = as1Springs{iSpring}; 
                M1 = Spring.M1;
                M2 = Spring.M2;
                if ~strcmp(Spring.Name,Name{iType}), continue; end
                if strcmp(Spring.Type,'Linear')
                    color = [0 1 0];
                elseif strcmp(Spring.Type,'GapComp')
                    if Spring.Displ < -Spring.gap
                        color = [0 1 0];
                    else
                        color = [1 1 1];
                    end
                elseif strcmp(Spring.Type,'GapTract')
                    if Spring.Displ > Spring.gap
                        color = [0 1 0];
                    else
                        color = [1 1 1];
                    end
                elseif strcmp(Spring.Type,'StickSlip')
                    Fact = abs(Spring.Force/Spring.ForceMax);
                    color = [Fact 1-Fact 0];
                elseif strcmp(Spring.Type,'3StepSpring')
                    Fact = abs(Spring.Force/Spring.FtRef);
                    if Fact > 1, Fact = 1; end
                    color = [Fact 1-Fact 0];
                end
                plot(XY([M1 M2],1)+ad1X([M1 M2]),XY([M1 M2],2)+ad1Y([M1 M2]),'color',color);
            end
            xlim([min(XY(:,1))-0.1 max(XY(:,1))+0.1]);
            ylim([min(XY(:,2))-0.1 max(XY(:,2))+0.1]);
            title([Name{iType} ' springs']);
            drawnow;
            hold off;
        end
        writeVideo(writerObj,getframe(gcf));
    end
end
if PLOT ~= 0 && ~isempty(VideoName)
    close(writerObj);
end
for iStar = 1: 1: length(STARS)
    if STARS(iStar) == 0
        STARS(iStar) = 1;
        fprintf(1, '*');
    end
end
fprintf(1, ']\n');
end

%% Integrating function
function output = ForcesAndMatrices(t,ad1U,ad1V,...
                ad2Mass, TopNodes,RightNodes, StressPaths, Ti, Tf)
global OUTPUT
lZ = max(ad2Mass(RightNodes,2))-min(ad2Mass(RightNodes,2));
lX = max(ad2Mass(TopNodes,1))-min(ad2Mass(TopNodes,1));
% External load
if t < 0
    Sconf = StressPaths(1,1)*(Ti-t)/Ti;
    Sdev = StressPaths(1,2)*(Ti-t)/Ti;
else
    FOUND = 0;
    t0 = 0;
    for iPath = 1: 1: size(StressPaths,1)
        if t <= t0 + StressPaths(iPath,4)/StressPaths(iPath,5)
            Sconf = StressPaths(iPath,1);
            SdevMin = StressPaths(iPath,2);
            SdevMax = StressPaths(iPath,3);
            Freq = StressPaths(iPath,5);
            FOUND = 1;
            break;
        else
            t0 = t0 + StressPaths(iPath,4)/StressPaths(iPath,5);
        end
    end
    if FOUND
        Sdev = (SdevMin+SdevMax)/2 + (-SdevMax+SdevMin)/2*cos(2*pi*Freq*t);
    else
        Sconf = StressPaths(end,1)*(1-(t-t0)/(Tf-t0));
        Sdev = StressPaths(end,2)*(1-(t-t0)/(Tf-t0));
    end
end

Fx = Sconf*lZ;
Fz = (Sconf+Sdev)*lX;
ad1Fext = zeros(2*size(ad2Mass,1),1);
ad1Fext(2*RightNodes-1) = -Fx/length(RightNodes);
ad1Fext(2*TopNodes) = -Fz/length(TopNodes);

if isempty(ad1U), ad1U = zeros(2*size(ad2Mass,1),1); end
if isempty(ad1V), ad1V = zeros(2*size(ad2Mass,1),1); end
% Internal forces and system matrices
if OUTPUT
    [ad1Fint, ad2K, ad2C, ad2M] = CalculateForcesAndMatrices(ad1U,ad1V,ad2Mass);
    dof = [ad2Mass(:,4)';ad2Mass(:,5)']; dof = find(dof(:));
    output.Fext = ad1Fext;
    output.Fint = ad1Fint;
    output.K = ad2K;
    output.C = ad2C;
    output.M = ad2M;
    output.dof = dof;
else
    ad1Fint = CalculateForcesAndMatrices(ad1U,ad1V,ad2Mass);
    output.Fext = ad1Fext;
    output.Fint = ad1Fint;
end
% Output
end
