%% Function for force and stiffness calculation of 3-phase spring
function [] = PlotDataFile(Filename)
clc
if nargin < 1, Filename = 'Friction_0p5_5p0_Try3.txt'; end

%% Find header length
pFile = fopen(Filename, 'rt');
nHeader = 0;
while 1
    STRING = fgetl(pFile);
    if STRING == -1, break; end
    if STRING(1) ~= '#', break; end
    nHeader = nHeader + 1;
end
fclose(pFile);

%% Read the data
DATA = importdata(Filename,' ',nHeader);
HEADER = DATA.textdata;
fprintf(1, '%s\n', HEADER{:});
ad1T = DATA.data(:,1);
ad1F = DATA.data(:,2);
ad1P = DATA.data(:,3);

%% Get maximum force, minimum force, frequency and number of cycles from
%  hearder
for iHeader = 1: 1: length(HEADER)
    STRING = HEADER{iHeader};
    % Fmin
    Index = strfind(STRING,'Fmin');
    if ~isempty(Index)
        Index = strfind(STRING,'=');
        Fmin = str2num(STRING(Index+1:end));
    end
    % Fmax
    Index = strfind(STRING,'Fmax');
    if ~isempty(Index)
        Index = strfind(STRING,'=');
        Fmax = str2num(STRING(Index+1:end));
    end
    % Frequency
    Index = strfind(STRING,'Frequency');
    if ~isempty(Index)
        Index = strfind(STRING,'=');
        Frequency = str2num(STRING(Index+1:end));
    end
    % nCycle
    Index = strfind(STRING,'N. cycles');
    if ~isempty(Index)
        Index = strfind(STRING,'=');
        nCycle = str2num(STRING(Index+1:end));
    end
end
%% Plot raw data
figure;
subplot(2,3,1), plot(ad1T, ad1F, 'b');
subplot(2,3,2), plot(ad1T, ad1P, 'b');
subplot(2,3,3), plot(ad1P, ad1F, 'b');

%% Find the location of each maximum and minimum forces. Remove repetitions
[MaxF,MaxI] = findpeaks(ad1F);
kI = 0;
while 1
    kI = kI + 1;
    if kI > length(MaxI), break; end
    Indeces = find(abs(ad1T(MaxI)-ad1T(MaxI(kI))) < 0.5/Frequency);
    [maxF, ind] = max(ad1F(MaxI(Indeces)));
    ind = MaxI(Indeces(ind));
    MaxI(Indeces(1)) = ind;
    MaxF(Indeces(1)) = maxF;
    MaxI(Indeces(2:end)) = [];
    MaxF(Indeces(2:end)) = [];
end

[MinF,MinI] = findpeaks(-ad1F); MinF = -MinF;
if MinI(1) ~= 1
    MinI = [1;MinI];
    MinF = [ad1F(1);MinF];
end
kI = 0;
while 1
    kI = kI + 1;
    if kI > length(MinI), break; end
    Indeces = find(abs(ad1T(MinI)-ad1T(MinI(kI))) < 0.5/Frequency);
    [minF, ind] = min(ad1F(MinI(Indeces)));
    ind = MinI(Indeces(ind));
    MinI(Indeces(1)) = ind;
    MinF(Indeces(1)) = maxF;
    MinI(Indeces(2:end)) = [];
    MinF(Indeces(2:end)) = [];
end

subplot(2,3,1); hold on
plot(ad1T(MaxI), ad1F(MaxI), 'or');
plot(ad1T(MinI), ad1F(MinI), 'ok');
hold off;
xlabel('time [s]');
ylabel('Force [N]');
subplot(2,3,2); hold on
plot(ad1T(MaxI), ad1P(MaxI), 'or');
plot(ad1T(MinI), ad1P(MinI), 'ok');
hold off;
xlabel('time [s]');
ylabel('Position [m]');
subplot(2,3,3); hold on
plot(ad1P(MaxI), ad1F(MaxI), 'or');
plot(ad1P(MinI), ad1F(MinI), 'ok');
hold off;
xlabel('Position [m]');
ylabel('Force [N]');

%% Calculate cycle informaiton
nCycle = length(MinI)-1;
P0 = ad1P(MinI(1));
Settlement = zeros(nCycle,1);
Kinc = zeros(nCycle,1);
Kdec = zeros(nCycle,1);
for iCycle = 1: 1: nCycle
    Settlement(iCycle) = P0 - ad1P(MinI(iCycle+1));
    Kinc(iCycle) = (ad1F(MaxI(iCycle))-ad1F(MinI(iCycle))) / (ad1P(MinI(iCycle))-ad1P(MaxI(iCycle)));
    Kdec(iCycle) = (ad1F(MinI(iCycle+1))-ad1F(MaxI(iCycle))) / (ad1P(MaxI(iCycle))-ad1P(MinI(iCycle+1)));
end
subplot(2,3,4), semilogx(1:1:nCycle,-Settlement); xlabel('Cycle n.'); ylabel('Settlement [m]');
subplot(2,3,5), semilogx(1:1:nCycle,Kinc); xlabel('Cycle n.'); ylabel('Stiffness loading [N/m]');
subplot(2,3,6), semilogx(1:1:nCycle,Kdec); xlabel('Cycle n.'); ylabel('Stiffness unloading [N/m]');
end