clc
clear

MACDOWEL = [
           -0.000000000000000001, -16.096609186310186;
            0.052910052910052796, -16.2483520539999;
            0.10052910052910047, -16.450060644412808;
            0.14550264550264536, -16.601803512102517;
            0.20899470899470907, -16.75446922955229;
            0.25396825396825395, -16.95604598428519;
            0.3121693121693121, -17.208115804461322;
            0.3650793650793651, -17.41008806623425;
            0.41534391534391535, -17.66176237937035;
            0.46825396825396814, -17.913568528186474;
            0.5211640211640209, -18.16537467700259;
            0.5899470899470898, -18.46780572694194;
            0.6666666666666665, -18.96996783209408;
            0.7433862433862433, -19.47212993724622;
            0.8148148148148147, -19.824526709908774;
            0.8703703703703702, -20.076464694404898;
            0.9259259259259258, -20.378236565944206;
            0.9682539682539681, -20.52984759795391;
            1.007936507936508, -20.780994568369987;
            1.0555555555555558, -21.132204819912467;
            1.1005291005291005, -21.433449348731745;
            1.1349206349206349, -21.58466487370142;
            1.17989417989418, -21.98557717660708;
            1.2301587301587302, -22.287085376786376;
            1.2724867724867726, -22.538364182882457;
            1.328042328042328, -22.889969941464962;
            1.3835978835978837, -23.341243474133844;
            1.439153439153439, -23.69284923271635;
            1.4947089947089944, -24.09428887834204;
            1.5291005291005293, -24.44483995148447;
            1.5634920634920637, -24.74555713758372;
            1.6058201058201056, -25.046669830722994;
            1.6507936507936507, -25.397748246585454;
            1.6878306878306875, -25.748431155407904;
            1.7301587301587302, -25.999709961503978;
            1.7777777777777781, -26.35092021304646;
            1.8412698412698414, -26.50358593049624;
            1.8888888888888888, -26.705294520909145;
            1.933862433862434, -26.807203501555666;
            2.00000000000001, -26.86006960923905];
MACDOWEL = [10.^MACDOWEL(:,1),MACDOWEL(:,2)];

OFFSET = 10;
if OFFSET ~= 0
    SETTLEMENT_OFFSET = interp1(MACDOWEL(:,1),MACDOWEL(:,2),OFFSET);
else
    SETTLEMENT_OFFSET = 0;
end

%% Main
Ks = 15e6;
Kf = 30e6;
SN = -(MACDOWEL(end,2)-SETTLEMENT_OFFSET)/1000;
Fmin = 3e3;
Fmax = 40e3;
FrefMax = Fmax;
FrefMin = 8000;

BETHA = 0.01:0.01:0.99;
GOOD = zeros(size(BETHA));
for iBetha = 1: 1: length(BETHA)
    betha = BETHA(iBetha);
    K1 = betha*Ks;
    K2 = Ks-K1;
    K3 = Kf-K1;
    g3 = SN;
    rMax = SN;
    F2Max = FrefMin * K2 / (K2 + K1);
    if F2Max/K2 - g3 > 0
        F2Max = (FrefMin + K3*g3) * K2 / (K1 + K2 + K3);
    end
    if (g3 > F2Max/K2 && g3 < (FrefMax-F2Max)/K1)
        GOOD(iBetha) = 1;
    end
end
BETHA(find(GOOD));
betha = 0.35;
K1 = Ks*betha;
K2 = Ks-K1;
K3 = Kf-K1;
rMax = SN-Fmin/(K1+K3);
g3 = rMax;
F2Max = FrefMin * K2 / (K2 + K1);
if F2Max/K2 - g3 > 0
    F2Max = (FrefMin + K3*g3) * K2 / (K1 + K2 + K3);
end
F2Min = 0;
F2Decrease = 0.03;

MinForce = Fmin;
AppliedForces = [1.0 1.0]*Fmax;
nMasses = 1;

K1 = K1*nMasses;   % Always active spring
K2 = K2*nMasses;     % Slide spring - only active if force < F2max
K3 = K3*nMasses;            % gap spring - only active if the springs has shortened the same amount as gap
rMax = rMax/nMasses;
g3 = g3/nMasses;

%% Main
COLORF = 'k';
% Fmin = 0;
% AppliedForce = 1;
% AppliedForces = [1.00 1.00 1.0]*AppliedForce;
% nMasses = 1;
% 
% alpha = 0.5; % Percentage of initial stiffness going to slide spring
% beta = 0.1;  % Increase of stiffness when comparing slide spring to gap spring
% 
% Kn = 1*nMasses;
% K1 = (1-alpha)*Kn;   % Always active spring
% K2 = K1/(1-alpha)*alpha;     % Slide spring - only active if force < F2max
% K3 = (1+beta)*K2;            % gap spring - only active if the springs has shortened the same amount as gap
% 
% SlideFact = 0.5; % Percentage of total force when slide starts (for first cycle)
% F2Max = AppliedForce/(K2+K1)*K2*SlideFact;
% F2Min = 0;
% F2Decrese = 0.1;
% GapFact = 0.8; % Allowable "free slide" before K3 is activated, as percentage of dispalcement when slide starts
% G3 = F2Max/K2*(1+GapFact);


%% Assemble masses and connections springs
ad2Mass = zeros(nMasses+1,5); % [X,Y,m,freeH,freeV]
for iMass = 0: 1: nMasses
    ad2Mass(iMass+1,:) = [0 nMasses-iMass 0 0 1];
end
ad2Mass(end,5) = 0;
global as1Springs;
as1Springs = {};
for iSpring = 1: 1: size(ad2Mass,1)-1
    Spring = CreateSpring('3StepSpring', iSpring, iSpring + 1, [0 1 0 -1], ...
                          K1, K2, K3, g3, F2Max, F2Decrease, Fmax, rMax);
    as1Springs{iSpring} = Spring;
end
global as1Springs2;
as1Springs2 = as1Springs;
%% Load cycles
ForceStep = (AppliedForces(end)-Fmin)/1000;
COLOR = 'brkgycm';
PLOT = 1:1:100;
color = 0;
ad1Uold = zeros(2*nMasses+2,1);
Settlement = zeros(nMasses,max(PLOT)*length(AppliedForces));
Stiffness = zeros(max(PLOT)*length(AppliedForces),1);
ad1Uold2 = zeros(2*nMasses+2,1);
Settlement2 = zeros(nMasses,max(PLOT)*length(AppliedForces));
Stiffness2 = zeros(max(PLOT)*length(AppliedForces),1);
kCycle = 0;
figure(1); hold off;
for iAmplitude = 1: 1: length(AppliedForces)
AppliedForce = AppliedForces(iAmplitude);
for iCycle = 1: 1: max(PLOT)
    if length(AppliedForces) == 1
        NextSET = -(interp1(MACDOWEL(:,1),MACDOWEL(:,2),iCycle)-SETTLEMENT_OFFSET)/nMasses/1000-Fmin/as1Springs2{1}.K1;
        dF = as1Springs2{1}.K1*NextSET-(as1Springs2{1}.F2Max0-as1Springs2{1}.F2Max);
        dF1 = as1Springs2{1}.K1*as1Springs2{1}.rMax-(as1Springs2{1}.F2Max0-as1Springs2{1}.F2Max);
        for iSpring = 1: 1: nMasses
            as1Springs2{iSpring}.ForceRed = dF/dF1;
        end
        if (iCycle > OFFSET)
            RED2(iCycle) = as1Springs2{1}.ForceRed;
        else
            RED2(iCycle) = nan;
            Settlement2(:,iCycle) = nan;
            Stiffness2(iCycle) = nan;
        end
    end
    kCycle = kCycle + 1;
    if (kCycle <= OFFSET)
        RED(kCycle) = nan;
        Settlement(:,kCycle) = nan;
        Stiffness(kCycle) = nan;
        continue;
    end
    RED(iCycle) = as1Springs{1}.ForceRed;
    fprintf(1, 'Calculating cycle %d ...', iCycle);
    ForceUp = Fmin:ForceStep:AppliedForce;
    Uup = zeros(nMasses+1,length(ForceUp));
    for iForce = 1: 1: length(ForceUp)
        ad1Force = zeros(2*nMasses+2,1);
        ad1Force(2) = -ForceUp(iForce);
        ad1U = ad1Uold;
        % Solve newton raphson
        as1SpringsTemp = as1Springs;
        while 1
            as1Springs = as1SpringsTemp;
            [ad1Fint, ad2K] = CalculateForcesAndMatrices(ad1U,ad1U*0,ad2Mass);
            ad1F = ad1Force(2:2:end-2)+ad1Fint(2:2:end-2);
            du = ad2K(2:2:end-2,2:2:end-2)\ad1F;
            ad1U(2:2:end-2) = ad1U(2:2:end-2)+du;
            if max(abs(ad1F)) <= 1e-4*abs(ad1Force(2)), break; end
%             if max(abs(ad1F)) <= 1e2*Kn*eps, break; end
        end
        % Update new values
        ad1Uold = ad1U;
        Uup(:,iForce) = ad1U(2:2:end);
    end
    ForceDown = AppliedForce:-ForceStep:Fmin;
    Udown = zeros(nMasses+1,length(ForceUp));
    for iForce = 1: 1: length(ForceDown)
        ad1Force = zeros(2*nMasses+2,1);
        ad1Force(2) = -ForceDown(iForce);
        ad1U = ad1Uold;
        % Solve newton raphson
        as1SpringsTemp = as1Springs;
        while 1
            as1Springs = as1SpringsTemp;
            [ad1Fint, ad2K] = CalculateForcesAndMatrices(ad1U,ad1U*0,ad2Mass);
            ad1F = ad1Force(2:2:end-2)+ad1Fint(2:2:end-2);
            du = ad2K(2:2:end-2,2:2:end-2)\ad1F;
            ad1U(2:2:end-2) = ad1U(2:2:end-2)+du;
            if max(abs(ad1F)) <= 1e-4*abs(ad1Force(2)), break; end
%             if max(abs(ad1F)) <= 1e2*Kn*eps, break; end
        end
        % Update new values
        ad1Uold = ad1U;
        Udown(:,iForce) = ad1U(2:2:end);
    end
    if length(AppliedForces) == 1
        Uup2 = zeros(nMasses+1,length(ForceUp));
        for iForce = 1: 1: length(ForceUp)
            ad1Force = zeros(2*nMasses+2,1);
            ad1Force(2) = -ForceUp(iForce);
            ad1U = ad1Uold2;
            % Solve newton raphson
            as1SpringsTemp = as1Springs;
            while 1
                as1Springs = as1Springs2;
                [ad1Fint, ad2K] = CalculateForcesAndMatrices(ad1U,ad1U*0,ad2Mass);
                ad1F = ad1Force(2:2:end-2)+ad1Fint(2:2:end-2);
                du = ad2K(2:2:end-2,2:2:end-2)\ad1F;
                ad1U(2:2:end-2) = ad1U(2:2:end-2)+du;
                if max(abs(ad1F)) <= 1e-4*abs(ad1Force(2)), break; end
    %             if max(abs(ad1F)) <= 1e2*Kn*eps, break; end
            end
            as1Springs2 = as1Springs;
            as1Springs = as1SpringsTemp;
            % Update new values
            ad1Uold2 = ad1U;
            Uup2(:,iForce) = ad1U(2:2:end);
        end
        ForceDown = AppliedForce:-ForceStep:Fmin;
        Udown2 = zeros(nMasses+1,length(ForceUp));
        for iForce = 1: 1: length(ForceDown)
            ad1Force = zeros(2*nMasses+2,1);
            ad1Force(2) = -ForceDown(iForce);
            ad1U = ad1Uold2;
            % Solve newton raphson
            as1SpringsTemp = as1Springs;
            while 1
                as1Springs = as1Springs2;
                [ad1Fint, ad2K] = CalculateForcesAndMatrices(ad1U,ad1U*0,ad2Mass);
                ad1F = ad1Force(2:2:end-2)+ad1Fint(2:2:end-2);
                du = ad2K(2:2:end-2,2:2:end-2)\ad1F;
                ad1U(2:2:end-2) = ad1U(2:2:end-2)+du;
                if max(abs(ad1F)) <= 1e-4*abs(ad1Force(2)), break; end
    %             if max(abs(ad1F)) <= 1e2*Kn*eps, break; end
            end
            as1Springs2 = as1Springs;
            as1Springs = as1SpringsTemp;
            % Update new values
            ad1Uold2 = ad1U;
            Udown2(:,iForce) = ad1U(2:2:end);
        end
    end
    if ~isempty(find(PLOT==iCycle))
        color = color + 1;
        for iMass = 1: 1: nMasses
            subplot(nMasses,3,(iMass-1)*3+1);
            plot(-Uup(iMass,:),ForceUp,COLOR(mod(color-1,7)+1)); hold on;
            plot(-Udown(iMass,:),ForceDown,COLOR(mod(color-1,7)+1)); hold on;
            drawnow;
        end
    end
    
    % Settlement and stiffness at the end of cycle
    Settlement(:,kCycle) = Udown(1:end-1,end);
    for iMass = 1: 1: nMasses
        subplot(nMasses,3,(iMass-1)*3+2);
        plot(1:1:kCycle,-Settlement(iMass,1:kCycle),'b');
        drawnow;
    end
    
    Stiffness(kCycle) = -(ForceUp(end)-ForceUp(1))/(Uup(1,end)-Uup(1,1));
    subplot(1,3,3);
    plot(1:1:kCycle,Stiffness(1:kCycle),'b'); hold on;
    drawnow;
    fprintf(1, ' done.\n');
    if kCycle == OFFSET + 1
        LoadUnLoadPath_1 = [[-Uup(1,:) -Udown(1,:)];[ForceUp ForceDown]];
    elseif kCycle == OFFSET + 10
        LoadUnLoadPath_10 = [[-Uup(1,:) -Udown(1,:)];[ForceUp ForceDown]];
    elseif kCycle == OFFSET + 100
        LoadUnLoadPath_100 = [[-Uup(1,:) -Udown(1,:)];[ForceUp ForceDown]];
    end
    
    if length(AppliedForces) == 1
        Settlement2(:,kCycle) = Udown2(1:end-1,end);
        Stiffness2(kCycle) = -(ForceUp(end)-ForceUp(1))/(Uup2(1,end)-Uup2(1,1));
        if kCycle == OFFSET + 1
            LoadUnLoadPath2_1 = [[-Uup2(1,:) -Udown2(1,:)];[ForceUp ForceDown]];
        elseif kCycle == OFFSET + 10
            LoadUnLoadPath2_10 = [[-Uup2(1,:) -Udown2(1,:)];[ForceUp ForceDown]];
        elseif kCycle == OFFSET + 100
            LoadUnLoadPath2_100 = [[-Uup2(1,:) -Udown2(1,:)];[ForceUp ForceDown]];
        end        
    end
    
end
end


close all;
figure(1);
plot(LoadUnLoadPath_1(1,:),LoadUnLoadPath_1(2,:),'b'); hold on
% plot(LoadUnLoadPath_10(1,:),LoadUnLoadPath_10(2,:),'b'); hold on
% plot(LoadUnLoadPath_100(1,:),LoadUnLoadPath_100(2,:),'b'); hold on
if length(AppliedForces) == 1
    plot(LoadUnLoadPath2_1(1,:),LoadUnLoadPath2_1(2,:),'r'); hold on
%     plot(LoadUnLoadPath2_10(1,:),LoadUnLoadPath2_10(2,:),'b'); hold on
%     plot(LoadUnLoadPath2_100(1,:),LoadUnLoadPath2_100(2,:),'b'); hold on
end
xlabel('Displacement (m)');
ylabel('Force (N)');
title('a)');
legend(['\beta_i = ' num2str(F2Decrease)], 'Variable \beta_i');
grid on;

figure(2);
semilogx((1:1:kCycle),Settlement(1,1:kCycle)*1000,'b'); hold on;
if length(AppliedForces) == 1
    semilogx(1:1:kCycle,Settlement2(1,1:kCycle)*1000,'r');
end
semilogx(MACDOWEL(:,1),MACDOWEL(:,2)-SETTLEMENT_OFFSET,'k'); hold off;
xlabel('Cycle number');
ylabel('Settlement (mm)');
legend(['\beta_i = ' num2str(F2Decrease)], 'Variable \beta_i', 'McDowell et al.');
title('b)');
grid on;
xlim([OFFSET kCycle]);

if length(AppliedForces) == 1
    figure(3)
    semilogx(1:1:kCycle,RED(1:kCycle),'b'); hold on
    if length(AppliedForces) == 1
        semilogx(1:1:kCycle,RED2(1:kCycle),'r'); hold on
    end
    xlabel('Cycle number');
    ylabel('\beta_i');
    title('c)');
    legend(['\beta_i = ' num2str(F2Decrease)], 'Variable \beta_i');
    grid on;
end