function PARTICLE = GetParticles(PLOT,WRITE)
if nargin < 1, PLOT = 1; end
if nargin < 2, WRITE = 1; end
Picture = 'BoxTest.bmp';

COLORMAP = imread(Picture);
DONE(1,1,1) = 0; DONE(1,1,2) = 0; DONE(1,1,3) = 0;
EDGE = COLORMAP(1,1,:); COLORMAP(1,1,:) = DONE;
CORNER = COLORMAP(1,2,:); COLORMAP(1,2,:) = DONE;

nCol = size(COLORMAP,2);
nRow = size(COLORMAP,1);


DIR = [1 0; 1 1; 0 1; -1 1; -1 0; -1 -1; 0 -1; 1 -1];

%% Read particles from bmp file
nParticle = 0;
for iCol = 1: 1: nCol
    for iRow = 1: 1: nRow
        if SameColor(COLORMAP(iRow,iCol,:),DONE), continue; end
        if ~SameColor(COLORMAP(iRow,iCol,:),EDGE) && ~SameColor(COLORMAP(iRow,iCol,:),CORNER)
            COLORMAP(iRow,iCol,:) = DONE;
            continue;
        end
        nParticle = nParticle + 1;
        nCorner = 0;
        if SameColor(COLORMAP(iRow,iCol,:),CORNER)
            nCorner = nCorner + 1;
            PARTICLE(nParticle).ad2Corner(nCorner,[1 2]) = [iRow iCol];
        end
        COLORMAP(iCol,iRow,:) = DONE;
        kRow = iRow; kCol = iCol;
        while 1
            FOUND = 0;
            for iDir = 1: 1: 8
                if kRow+DIR(iDir,1) < 1 || kRow+DIR(iDir,1) > nRow || ...
                    kCol+DIR(iDir,2) < 1 || kCol+DIR(iDir,2) > nCol, continue; end
                if SameColor(COLORMAP(kRow+DIR(iDir,1),kCol+DIR(iDir,2),:), CORNER)
                    FOUND = 1;
                    COLORMAP(kRow,kCol,:) = DONE;
                    kRow = kRow+DIR(iDir,1); kCol = kCol+DIR(iDir,2);
                    nCorner = nCorner + 1;
                    PARTICLE(nParticle).ad2Corner(nCorner,[1 2]) = [kRow kCol];
                    break;
                elseif SameColor(COLORMAP(kRow+DIR(iDir,1),kCol+DIR(iDir,2),:), EDGE)
                    FOUND = 1;
                    COLORMAP(kRow,kCol,:) = DONE;
                    kRow = kRow+DIR(iDir,1); kCol = kCol+DIR(iDir,2);
                    break;
                else
                    COLORMAP(kRow+DIR(iDir,1),kCol+DIR(iDir,2),:) = DONE;
                end
            end
            if ~FOUND
                COLORMAP(kRow,kCol,:) = DONE;
                break;
            end
        end
    end
end

%% Plot the particles (as they were read)
if PLOT
    figure; hold on;
    for iParticle = 1: 1: length(PARTICLE)
        ad2Corner = PARTICLE(iParticle).ad2Corner([1:end 1],:);
        for iCorner = 1: 1: size(ad2Corner,1)-1
            plot(ad2Corner([iCorner iCorner+1],1), ad2Corner([iCorner iCorner+1],2), 'b');
        end
    end
    axis equal
end
%% Scale the particles such that their maximum dimension is 1, and plot them
if PLOT
    figure;
    nCol = sqrt(length(PARTICLE));
    nRow = ceil(length(PARTICLE)/nCol);
end
for iParticle = 1: 1: length(PARTICLE)
    % Scale
    ad2Corner = PARTICLE(iParticle).ad2Corner;
    MaxDist = 0;
    for iCorner = 1: 1: size(ad2Corner,1)
        for jCorner = iCorner+1: 1: size(ad2Corner,1)
            Dist = norm(ad2Corner(iCorner,:)-ad2Corner(jCorner,:));
            if Dist > MaxDist, MaxDist = Dist; end
        end
    end
    Scale = 1/MaxDist;
    for iCorner = 2: 1: size(ad2Corner,1)
        ad2Corner(iCorner,:) = (ad2Corner(iCorner,:)-ad2Corner(1,:))*Scale;
    end
    ad2Corner(1,:) = [0 0];
    offSetX = (max(ad2Corner(:,1))+min(ad2Corner(:,1)))/2;
    offSetY = (max(ad2Corner(:,2))+min(ad2Corner(:,2)))/2;
    ad2Corner(:,1) = ad2Corner(:,1)-offSetX;
    ad2Corner(:,2) = ad2Corner(:,2)-offSetY;
    PARTICLE(iParticle).ad2Corner = ad2Corner;
    % Calculate area and centre of gravity
    ad2Corner = [ad2Corner; ad2Corner(1,[1 2])];
    AREA = 0;
    xcg = 0;
    ycg = 0;
    for iCorner =  1: 1: size(ad2Corner,1)-1
        x1 = ad2Corner(iCorner,1);   y1 = ad2Corner(iCorner,2);
        x2 = ad2Corner(iCorner+1,1); y2 = ad2Corner(iCorner+1,2);
        L1 = sqrt(x1^2+y1^2); A1 = atan2(y1, x1);
        L2 = sqrt(x2^2+y2^2); A2 = atan2(y2, x2);
        SIN = abs(sin(A2-A1));
        area = 1/2*L1*L2*SIN;
        AREA = AREA + area;
        
        S = [x2/2-x1 -x1/2+x2; y2/2-y1 -y1/2+y2]^-1*[x2-x1;y2-y1];
        xc = x1+(x2/2-x1)*S(1);
        yc = y1+(y2/2-y1)*S(1);
        xcg = xcg + xc*area;
        ycg = ycg + yc*area;
    end
    % Shift centre of gravity
    xcg = xcg/AREA;
    ycg = ycg/AREA;
    ad2Corner(:,1) = ad2Corner(:,1) - xcg;
    ad2Corner(:,2) = ad2Corner(:,2) - ycg;
    % Calcule moment of inertia
    INERTIA = 0;
    for iCorner =  1: 1: size(ad2Corner,1)-1
        x1 = ad2Corner(iCorner,1);   y1 = ad2Corner(iCorner,2);
        x2 = ad2Corner(iCorner+1,1); y2 = ad2Corner(iCorner+1,2);
        L1 = sqrt(x1^2+y1^2); A1 = atan2(y1, x1);
        L2 = sqrt(x2^2+y2^2); A2 = atan2(y2, x2);
        SIN = abs(sin(A2-A1)); COS = sqrt(1-SIN^2);
        
        b = L1;
        h = L2*SIN;
        a = L2*COS;
        if a > b
            b = L2;
            h = L1*SIN;
            a = L1*COS;
        end
        INERTIA = INERTIA + (h*b^3+h*a*b^2+h*a^2*b+b*h^3)/12;
    end
    ad2Corner = ad2Corner(1:end-1,:);
    
    PARTICLE(iParticle).ad2Corner = ad2Corner;
    PARTICLE(iParticle).AREA = AREA;
    PARTICLE(iParticle).INERTIA = INERTIA;
    % Plot
    if PLOT
        subplot(nRow,nCol,iParticle); hold on; plot(0,0,'b*');
        ad2Corner = PARTICLE(iParticle).ad2Corner([1:end 1],:);
        for iCorner = 1: 1: size(ad2Corner,1)-1
            plot(ad2Corner([iCorner iCorner+1],1), ad2Corner([iCorner iCorner+1],2), 'b');
        end
        title(['A = ' num2str(AREA) ', I = ' num2str(INERTIA)]);
        axis equal
    end
end
%% Write the file
if WRITE
    pFile = fopen('particles.bin', 'wb');
    nParticles = length(PARTICLE);
    fwrite(pFile, nParticles, 'int'); % nParticle
    for iParticle  = 1: 1: nParticles
        nCorner = size(PARTICLE(iParticle).ad2Corner,1);
        fwrite(pFile, nCorner, 'int'); % nCroner
        for iCorner = 1: 1: nCorner
            fwrite(pFile, PARTICLE(iParticle).ad2Corner(iCorner,1), 'double'); % X
            fwrite(pFile, PARTICLE(iParticle).ad2Corner(iCorner,2), 'double'); % Y
        end
        fwrite(pFile, PARTICLE(iParticle).AREA, 'double'); % Area
        fwrite(pFile, PARTICLE(iParticle).INERTIA, 'double'); % Inertia
    end
    fclose(pFile);
end
end

%% Check if two colors are the same
function TF = SameColor(A,B)
TF = 0;
if A(1) ~= B(1), return; end
if A(2) ~= B(2), return; end
if A(3) ~= B(3), return; end
TF = 1;
end

    