function PARTICLES = FillBox(Width,Height,DiamMean,DiamStd)
%% Inputs
if nargin < 4, DiamStd = 0.0125; end
if nargin < 3, DiamMean = 0.0375; end
if nargin < 2, Height = 0.3; end
if nargin < 1, Width = 0.7; end

%% Get particle shapes
PARTICLE = GetParticles();

%% Randomly distribute the particles
nParticle = 0;
iY = 0;
TotalArea = 0;
Ymax = 0;
while TotalArea < 0.75*Width*Height
    iY = iY + 1;
    for iX = 1: 1: ceil(Width/(DiamMean+DiamStd))
        nParticle = nParticle + 1;
        particle = 1+floor(rand*length(PARTICLE));
        Diam = DiamMean + DiamStd*randn(1,1);
        if Diam < DiamMean-DiamStd, Diam = DiamMean-DiamStd; end
        if Diam > DiamMean+DiamStd, Diam = DiamMean+DiamStd; end
        Angle = 2*pi*rand; COS = cos(Angle); SIN = sin(Angle);
        Pos = [-Width/2 0] + [iX-0.5 iY-0.5]*(DiamMean+DiamStd);
        ad2Corner = PARTICLE(particle).ad2Corner*Diam;
        ad2Corner = ad2Corner*[COS SIN; -SIN COS];
        ad2Corner(:,1) = ad2Corner(:,1) + Pos(1);
        ad2Corner(:,2) = ad2Corner(:,2) + Pos(2);
        PARTICLES(nParticle).ad2Corner = ad2Corner;
        PARTICLES(nParticle).AREA = PARTICLE(particle).AREA*Diam*Diam;
        TotalArea = TotalArea + PARTICLES(nParticle).AREA;
        Ymax = max([Ymax;ad2Corner(:,2)]);
    end
end
%% Plot the particles
figure; hold on;
for iParticle = 1: 1: length(PARTICLES)
    ad2Corner = PARTICLES(iParticle).ad2Corner([1:end 1],:);
    for iCorner = 1: 1: size(ad2Corner,1)-1
        plot(ad2Corner([iCorner iCorner+1],1), ad2Corner([iCorner iCorner+1],2), 'b');
    end
end
axis equal
hold off

%% Write file to be read by CompressionTest
pFile = fopen('Inputs.bin', 'wb');
fwrite(pFile, -Width/2, 'double'); % Xmin
fwrite(pFile, Width/2, 'double');  % Xmax
fwrite(pFile, 0, 'double');         % Ymin
fwrite(pFile, 1.1*Ymax, 'double');  % Ymax
fwrite(pFile, length(PARTICLES), 'int'); % n. of particles
for iParticle = 1: 1: length(PARTICLES)
    nCorner = size(PARTICLES(iParticle).ad2Corner,1);
    fwrite(pFile, nCorner, 'int'); % N. or corners of particles
    for iCorner = 1: 1: nCorner
        fwrite(pFile, PARTICLES(iParticle).ad2Corner(iCorner,1), 'double'); % Xcorner
        fwrite(pFile, PARTICLES(iParticle).ad2Corner(iCorner,2), 'double'); % Ycorner
    end
end
fclose(pFile);
end