%% CreateSpring
%  Options:
%  1. Creating an empty spring:
%     Spring = CreateSpring();
%
%  2. Creating a linear spring
%     Spring = CreateSpring('Linear', M1, M2, dofs, K);
%     M1   - mass 1
%     M2   - mass2
%     dofs - degress of freedom defining extension (positive in traction)
%     K    - spring stiffness
%
%  3. Creating a traction spring with a gap
%     Spring = CreateSpring('GapTract', M1, M2, dofs, K, gap);
%     M1   - mass 1
%     M2   - mass2
%     dofs - degress of freedom defining extension (positive in traction)
%     K    - spring stiffness
%     gap  - gap at which spring becomes active (positive)
%
%  4. Creating a compression spring with a gap
%     Spring = CreateSpring('GapComp', M1, M2, dofs, K, gap);
%     M1   - mass 1
%     M2   - mass2
%     dofs - degress of freedom defining extension (positive in traction)
%     K    - spring stiffness
%     gap  - gap at which spring becomes active (positive)
%
%  5. Creating a stick-slip spring
%     Spring = CreateSpring('StickSlip', M1, M2, dofs, K, Fmax, FmaxRed);
%     M1      - mass 1
%     M2      - mass2
%     dofs    - degress of freedom defining extension (positive in traction)
%     K       - spring stiffness
%     Fmax    - Force (in absolute value) above which spring becomes inactive
%     FmaxRed - Factor determining the reduction of Fmax
%               (optional. Default = 0)
%
%  6. Creating a 3 stage compression spring
%     Spring = CreateSpring('3StepSpring', M1, M2, dofs, K1, K2, K3, gap, F2max, F2maxRed, Fref, F2min0);
%     M1       - mass 1
%     M2       - mass2
%     dofs     - degress of freedom defining extension (positive in traction)
%     K1       - spring stiffness (linear part)
%     K2       - spring stiffness (stick-slip part)
%     K3       - spring stiffness (gap part)
%     gap      - gap associated to K3 (positive)
%     F2max    - Force of spring 2 (absolute value) above which spring
%                becomes inactive (positivein compression compression only)
%     F2maxRed - Factor determining the reduction of F2max
%                (optional. Default = 0)
%     Fref     - Reference force to define the maximum decay of F2max
%     F2min0   - Initial minimum force (maximum traction) of spring 2
%     Ks       - Stiffness of shear spring
%     Fric     - Friction (to calculate the maximum force)
%     Cs       - Damping in shear direction
function Spring = CreateSpring(I1,I2,I3,I4,I5,I6,I7,I8,I9,I10,I11,I12)
Spring.Name = [];
Spring.M1 = [];
Spring.M2 = [];
Spring.dofs = [];
Spring.Type = [];
Spring.K = [];
Spring.gap = [];
Spring.Stick = 1;
Spring.Displ = 0;
Spring.ForceMax = [];
Spring.ForceRed = 0;
Spring.Force = 0;
Spring.F1 = 0;
Spring.F2 = 0;
Spring.F3 = 0;
Spring.K1 = [];
Spring.K2 = [];
Spring.F2Max0 = [];
Spring.F2Max = [];
Spring.F2MaxTemp = 0;
Spring.rMax = 0;
Spring.Slide = 0;
Spring.K3 = [];
Spring.FtMax = 0;
Spring.FtRef = [];
Spring.C = 0;
Spring.Ks = [];
Spring.Fric = [];
Spring.Cs = [];
Spring.dofsT = [];
Spring.StickT = 1;
Spring.DisplT = 0;
Spring.ForceT = 0;
if nargin == 0
    return;
elseif strcmp(I1, 'Linear')
    if nargin ~= 5
        fprintf(1,'ERROR: for springs type Linear, the call is:\n');
        fprintf(1,'       Spring = CreateSpring(''Linear'', M1, M2, dofs, K)\n');
        return;
    end
    Spring.Type = I1;
    Spring.M1 = I2;
    Spring.M2 = I3;
    Spring.dofs = I4;
    Spring.K = I5;
elseif strcmp(I1,'GapComp')
    if nargin ~=6
        fprintf(1,'ERROR: for springs type GapComp, the call is:\n');
        fprintf(1,'       Spring = CreateSpring(''GapComp'', M1, M2, dofs, K, gap)\n');
        return;
    end
    Spring.Type = I1;    
    Spring.M1 = I2;
    Spring.M2 = I3;
    Spring.dofs = I4;
    Spring.K = I5;
    Spring.gap = I6;
elseif strcmp(I1,'GapTract')
    if nargin ~=6
        fprintf(1,'ERROR: for springs type GapTract, the call is:\n');
        fprintf(1,'       Spring = CreateSpring(''GapTract'', M1, M2, dofs, K, gap)\n');
        return;
    end
    Spring.Type = I1;
    Spring.M1 = I2;
    Spring.M2 = I3;
    Spring.dofs = I4;
    Spring.K = I5;
    Spring.gap = I6;
elseif strcmp(I1, 'StickSlip')
    if nargin ~= 6 && nargin ~= 7
        fprintf(1,'ERROR: for springs type StickSlip, the call is:\n');
        fprintf(1,'       Spring = CreateSpring(''StickSlip'', M1, M2, dofs, K, Fmax, FmaxRed(opt))\n');
        return;
    end
    Spring.Type = I1;
    Spring.M1 = I2;
    Spring.M2 = I3;
    Spring.dofs = I4;
    Spring.K = I5;
    Spring.ForceMax = I6;
    Spring.F2Max0 = I6;
    Spring.Stick = 1;
    Spring.Displ = 0;
    Spring.ForceRed=0;
    Spring.Force=0;
    if nargin == 7
        Spring.ForceRed = I7;
    end
elseif strcmp(I1, '3StepSpring')
    if nargin ~= 9 && nargin ~= 10 && nargin ~= 11 && nargin ~= 12
        fprintf(1,'ERROR: for springs type StickSlip, the call is:\n');
        fprintf(1,'       Spring = CreateSpring(''3StepSpring'', M1, M2, dofs, K1, K2, K3, gap, F2max, F2maxRed(opt), Fref(opt), F2min0(opt))\n');
        return;
    end
    Spring.Type = I1;
    Spring.M1 = I2;
    Spring.M2 = I3;
    Spring.dofs = I4;
    Spring.K1 = I5;
    Spring.K2 = I6;
    Spring.K3 = I7;
    Spring.gap = I8;
    Spring.F2Max0 = I9;
    Spring.F2Max = I9;
    Spring.F2MaxTemp = I9;
    Spring.Slide = 0;
    Spring.ForceRed = 0;
    if nargin > 9
        Spring.ForceRed = I10;
    end
    Spring.FtRef = I9/I6*(I5+I6)+0.1*I8*I7;
    if nargin > 10
        Spring.FtRef = I11;
    end
    Spring.rMax = 0;
    if nargin > 11
        Spring.rMax = I12;
    end
    Spring.Stick = 1;
    Spring.FtMax = 0;
else
    fprintf(1,'ERROR: unkown type of spring.\n');
    return;
end

end