function [ad2Mass,as1Springs] = CreateLattice(...
                       Length,Height,D,...
                       m,Kn_1,Kn_2,Kn_3,Cn,G3,F2Max,F2red,Fref,rMax,...
                       Ks,Cs,Fmax_s,Fred_s,...
                       Kd_1,Kd_2,Kd_3,Cd,G3_d,F2Max_d,F2red_d,Fref_d,rMax_d,...
                       Fric)
if nargin < 25, Fric = 0; end
as1Springs = {};
nMassH = round(Length/D) + 1;
nMassV = round(Height/D) + 1;
Length = (nMassH-1) * D;
Height = (nMassV-1) * D;
nMass = nMassH * nMassV;
%% Create masses
ad2Mass = zeros(nMass,5); % [X,Y,m,freeH,freeV]
kMass = 0;
x = -Length/2;
for iMassH = 0:1:nMassH-1
    y = 0;
    for iMassV = 0:1:nMassV-1
        kMass = kMass + 1;
        ad2Mass(kMass,1) = x;
        ad2Mass(kMass,2) = y;
        ad2Mass(kMass,3) = m;
        ad2Mass(kMass,4) = 1;
        if iMassH == 0 || iMassH == nMassH-1
            ad2Mass(kMass,4) = 0;
        end
        ad2Mass(kMass,5) = 1;
        if iMassV == nMassV-1
            ad2Mass(kMass,5) = 0;
        end
        y = y - Height/(nMassV-1);
    end
    x = x + Length/(nMassH-1);
end

%% Connections
kSpring = 0;
% Vertical connections
for iV = 1: 1: nMassV-1
    for iH = 1: 1: nMassH
        % Normal
        kSpring = kSpring + 1;
        as1Springs{kSpring} = CreateSpring('3StepSpring', ...
                          (iH-1)*nMassV + iV, (iH-1)*nMassV + iV + 1, [0 1 0 -1], ...
                          Kn_1, Kn_2, Kn_3, G3, F2Max, F2red, Fref, rMax);
        as1Springs{kSpring}.C = Cn;
        as1Springs{kSpring}.Name = 'Normal';
        % Shear
        if Ks ~= 0 && Fric ~= 0
            as1Springs{kSpring}.Ks = Ks;
            as1Springs{kSpring}.Cs = Cn*Ks/(Kn_1+Kn_2);
            as1Springs{kSpring}.Fric = Fric;
            as1Springs{kSpring}.dofsT = [1 0 -1 0];
        elseif Ks ~= 0 && Fric == 0
            kSpring = kSpring + 1;
            as1Springs{kSpring} = CreateSpring('StickSlip', ...
                            (iH-1)*nMassV + iV, (iH-1)*nMassV + iV + 1, ...
                            [1 0 -1 0], Ks, Fmax_s, Fred_s);
            as1Springs{kSpring}.C = Cs;
            as1Springs{kSpring}.Name = 'Shear';
        end
    end
end
% Horizontal connections
for iV = 1: 1: nMassV
    for iH = 1: 1: nMassH-1
        % Normal
        kSpring = kSpring + 1;
        as1Springs{kSpring} = CreateSpring('3StepSpring', ...
                          (iH-1)*nMassV + iV, iH*nMassV + iV, [-1 0 1 0], ...
                          Kn_1, Kn_2, Kn_3, G3, F2Max, F2red, Fref, rMax);
        as1Springs{kSpring}.C = Cn;
        as1Springs{kSpring}.Name = 'Normal';
        % Shear
        if Ks ~= 0 && Fric ~= 0
            as1Springs{kSpring}.Ks = Ks;
            as1Springs{kSpring}.Cs = Cn*Ks/(Kn_1+Kn_2);
            as1Springs{kSpring}.Fric = 1;
            as1Springs{kSpring}.dofsT = [0 1 0 -1];
        elseif Ks ~= 0 && Fric == 0
            kSpring = kSpring + 1;
            as1Springs{kSpring} = CreateSpring('StickSlip', ...
                            (iH-1)*nMassV + iV, iH*nMassV + iV, ...
                            [0 1 0 -1], Ks, Fmax_s, Fred_s);
            as1Springs{kSpring}.C = Cs;
            as1Springs{kSpring}.Name = 'Shear';
        end
    end
end
% Diagonal connections
if (Kd_1+Kd_2) ~= 0
    for iV = 1: 1: nMassV-1
        for iH = 1: 1: nMassH-1
            if ~isempty(Kd_1) && Kd_1 ~= 0
                % Diag 1
                kSpring = kSpring + 1;
                as1Springs{kSpring} = CreateSpring('3StepSpring', ...
                              (iH-1)*nMassV + iV, iH*nMassV + (iV+1), sqrt(2)/2 * [-1 1 1 -1], ...
                              Kd_1, Kd_2, Kd_3, G3_d, F2Max_d, F2red_d, Fref_d, rMax_d);
                as1Springs{kSpring}.C = Cd;
                as1Springs{kSpring}.Name = 'Diagonal';


                % Diag2
                kSpring = kSpring + 1;
                as1Springs{kSpring} = CreateSpring('3StepSpring', ...
                              iH*nMassV + iV, (iH-1)*nMassV + (iV+1), sqrt(2)/2 * [1 1 -1 -1], ...
                              Kd_1, Kd_2, Kd_3, G3_d, F2Max_d, F2red_d, Fref_d, rMax_d);
                as1Springs{kSpring}.C = Cd;
                as1Springs{kSpring}.Name = 'Diagonal';
            else
                % Diag 1
                kSpring = kSpring + 1;
                as1Springs{kSpring} = CreateSpring('StickSlip', ...
                              (iH-1)*nMassV + iV, iH*nMassV + (iV+1), sqrt(2)/2 * [-1 1 1 -1], ...
                               Kd_2, F2Max_d, F2red_d);
                as1Springs{kSpring}.C = Cd;
                as1Springs{kSpring}.Name = 'Diagonal';


                % Diag2
                kSpring = kSpring + 1;
                as1Springs{kSpring} = CreateSpring('StickSlip', ...
                              iH*nMassV + iV, (iH-1)*nMassV + (iV+1), sqrt(2)/2 * [1 1 -1 -1], ...
                              Kd_2, F2Max_d, F2red_d);
                as1Springs{kSpring}.C = Cd;
                as1Springs{kSpring}.Name = 'Diagonal';
            end
        end
    end
end

end