function [Force,K,SpringOut] = CalculateSpringForce(Spring,Displ)
SpringOut = Spring;
Type = SpringOut.Type;
K = SpringOut.K;
if strcmp(Type,'Linear')
    Force = K*Displ;
    SpringOut.Force = Force;
elseif strcmp(Type,'GapComp')
    gap = SpringOut.gap;
    Force = K*(Displ+gap);
    if Force > 0
        Force = 0;
        K = 0;
    end
    SpringOut.Force = Force;
elseif strcmp(Type,'GapTract')
    gap = SpringOut.gap;
    Force = K*(Displ-gap);
    if Force < 0
        Force = 0;
        K = 0;
    end
    SpringOut.Force = Force;
elseif strcmp(Type,'StickSlip')
    Stick = SpringOut.Stick;
    DisplOld = SpringOut.Displ;
    ForceMax = SpringOut.ForceMax;
    ForceRed = SpringOut.ForceRed;
    Force = SpringOut.Force + K*(Displ-DisplOld);
    if abs(Force) > ForceMax
        Force = sign(Force)*abs(ForceMax);
        K = 0;
        Stick = 0;
    elseif Stick == 0 && abs(Force) > abs(SpringOut.Force)
        Force = sign(Force)*abs(SpringOut.Force);
        K = 0;
        Stick = 0;
    elseif Stick == 0 && abs(Force) > (1-ForceRed)*ForceMax
        Stick = 0;
    elseif Stick == 0
        ForceMax = (1-ForceRed)*ForceMax;
        Stick = 1;
    end
    SpringOut.Force = Force;
    SpringOut.Displ = Displ;
    SpringOut.Stick = Stick;
    SpringOut.ForceMax = ForceMax;
elseif strcmp(Type,'3StepSpring')
    K1 = SpringOut.K1;
    K2 = SpringOut.K2;
    F2Max0 = SpringOut.F2Max0;
    F2Max = SpringOut.F2Max;
    F2MaxTemp = SpringOut.F2MaxTemp;
    S2 = SpringOut.Slide;
    F2Decrese = SpringOut.ForceRed;
    K3 = SpringOut.K3;
    G3 = SpringOut.gap;
    Stick = SpringOut.Stick;
    FtMax = SpringOut.FtMax;
    FtRef = SpringOut.FtRef;
    rMax = SpringOut.rMax;
    [Force,S2,Stick,F2Max,F2MaxTemp,FtMax,K] = ...
                CalculateForceNL(K1,K2,F2Max0,F2Max,F2MaxTemp,rMax,S2,F2Decrese,K3,G3,Stick,-Displ,FtMax,FtRef);
    Force = -Force;
    SpringOut.Force = Force;
    SpringOut.Slide = S2;
    SpringOut.Stick = Stick;
    SpringOut.F2Max = F2Max;
    SpringOut.F2MaxTemp = F2MaxTemp;
    SpringOut.FtMax = FtMax;
end
end

function [Force,S,STICKout,F2Maxout,F2MaxTempout,FtMaxout,K] = ...
                CalculateForceNL(K1,K2,F2Max0,F2Max,F2MaxTemp,rMax,S2,F2Decrese,K3,G3,STICKin,Displ,FtMax,FtRef)
F2Maxout = F2Max;
STICKout = 1;
Force1 = K1*Displ;
Force3 = K3*(Displ-G3); if Force3 < 0, Force3 = 0; end
Force2 = K2*(Displ-S2); S = S2;
Ft = FtMax;
if Ft > FtRef
    Ft = FtRef;
end
F2min = (F2Max-F2Max0);
FrefMin = F2Max0*(K1+K2)/K2+K3*max(0,F2Max0/K2-G3);
DeltaF2 = F2Decrese*((Ft-FrefMin)/(FtRef-FrefMin)*K1*rMax+F2min);
F2MaxTempout = F2MaxTemp;
if DeltaF2 < 0, DeltaF2 = 0; end
if nargout > 6
    K = K1;
    if Force3 > 0
        K = K + K3;
    end
end
if Force2 > F2MaxTemp
    Force2 = F2MaxTemp;
    S = Displ-Force2/K2;
    STICKout = 0;
elseif STICKin == 0 && Force2 > F2Max-DeltaF2
    F2MaxTempout = Force2;
    STICKout = 0;
    if nargout > 6
        K = K + K2;
    end
elseif STICKin == 0
    F2Maxout = F2Max - DeltaF2;
    F2MaxTempout = F2Maxout;
    Force2 = K2*(Displ-S);
    if nargout > 6
        K = K + K2;
    end
    FtMax = Force1 + Force2 + Force3;
elseif nargout > 6
    K = K + K2;
end
if Force2 < (F2MaxTempout-F2Max0)
    Force2 = (F2MaxTempout-F2Max0);
    S = Displ - Force2/K2;
    if nargout > 6
        K = K - K2;
    end
    FtMax = Force1 + Force2 + Force3;
end
Force = Force1 + Force2 + Force3;
FtMaxout = FtMax;
if Force > FtMax
    FtMaxout = Force;
end
end