%% Constitutive laws for connections
function [ad1Fint,ad2K,ad2C,ad2M] = CalculateForcesAndMatrices(ad1U,ad1V,ad2Mass)
global as1Springs
nDof = size(ad1U,1);
nSpring = length(as1Springs);
ad1Fint = zeros(nDof,1);
if nargout > 1
    ad2K = zeros(16*nSpring,3); kNZT_K = 0;
    ad2C = zeros(16*nSpring,3); kNZT_C = 0;
    ad2M = zeros(nDof,3);
    for iMass = 1: 1: size(ad2Mass,1)
        ad2M(2*(iMass-1)+(1:2),:) = [2*iMass-1 2*iMass-1 ad2Mass(iMass,3);
                                     2*iMass   2*iMass   ad2Mass(iMass,3)];
    end
    ad2M = sparse(ad2M(:,1),ad2M(:,2),ad2M(:,3),nDof,nDof);
end
for iSpring = 1: 1: nSpring
    Spring = as1Springs{iSpring};
    M1 = Spring.M1;
    M2 = Spring.M2;
    C = Spring.C;
    dofs = [2*M1-1 2*M1 2*M2-1 2*M2]';
    DOFn = Spring.dofs;
    dn = DOFn * ad1U(dofs);
    [Fn,K,Spring] = CalculateSpringForce(Spring,dn);
    vn = DOFn * ad1V(dofs);
    FnC = C*vn;
    ad1Fint(dofs) = ad1Fint(dofs) - DOFn'*(Fn+FnC);
    % Calculate shear force
    if ~isempty(Spring.Ks)
        Ks = Spring.Ks;
        Cs = Spring.Cs;
        if isempty(Cs), Cs = 0; end
        DOFt = Spring.dofsT;
        if isempty(DOFt)
            DOFt = [DOFn(2) -DOFn(1) -DOFn(2) DOFn(1)];
        end
        Fric = Spring.Fric;
        FmaxS = inf;
        if ~isempty(Fric), FmaxS = abs(Fn)*Fric; end
        ds = DOFt * ad1U(dofs);
        
        Stick = Spring.StickT;
        Fs = Spring.ForceT + Ks*(ds-Spring.DisplT);
        if abs(Fs) > FmaxS
            Fs = sign(Fs)*FmaxS;
            Ks = 0;
            Stick = 0;
        elseif Stick == 0 && abs(Fs) > FmaxS
            Fs = sign(Fs)*FmaxS;
            Ks = 0;
            Stick = 0;
        elseif Stick == 0
            Stick = 1;
        end
        Spring.ForceT = Fs;
        Spring.DisplT = ds;
        Spring.StickT = Stick;

        vs = DOFt * ad1V(dofs);
        FsC = Cs*vs;
        ad1Fint(dofs) = ad1Fint(dofs) - DOFt'*(Fs+FsC);
    end
    as1Springs{iSpring} = Spring;
    if nargout > 1
        ad2KElem = DOFn'*K*DOFn;
        ad2CElem = DOFn'*C*DOFn;
        if ~isempty(Spring.Ks)
            ad2KElem = ad2KElem + DOFt'*Ks*DOFt;
            ad2CElem = ad2CElem + DOFt'*Cs*DOFt;
        end
        [row,col,val] = find(ad2KElem);
        ad2K(kNZT_K+(1:length(row)),:) = [dofs(row) dofs(col) val]; kNZT_K = kNZT_K + length(row);
        [row,col,val] = find(ad2CElem);
        ad2C(kNZT_C+(1:length(row)),:) = [dofs(row) dofs(col) val]; kNZT_C = kNZT_C + length(row);
    end
end
% Convert final matrices to sparse
if nargout > 1
    ad2K = sparse(ad2K(1:kNZT_K,1),ad2K(1:kNZT_K,2),ad2K(1:kNZT_K,3),nDof,nDof);
    ad2C = sparse(ad2C(1:kNZT_C,1),ad2C(1:kNZT_C,2),ad2C(1:kNZT_C,3),nDof,nDof);
end
end