%% For-loops for the data analysis, the SNR plots and the statistics
% LB, Si, Si+, SiO2, Sio2+ and Graphene; + indicates APTES
% y./ymean followed by rms of this signal.

clear all
clc
%% LB (noise measurement)
j = 4:46;
for i = 1:length(j)
    jj = j(i);
    strname = sprintf('OSC_ecoli_7740_silicon_LB_%i',jj);
    load(strname);
    XXX(i).t_start = min(meas.t);%data(jj).t);
    XXX(i).t_end = max(meas.t);%data(jj).t);
    XXX(i).y = meas.y;
    ydat = XXX(i).y;
    P = polyfit(meas.t,meas.y,1);
    yplot = meas.y  - P(1)*meas.t - P(2);
    ynm = (yplot./mean(ydat))./ 0.0038; % max 40 nm
    vars(i) = var(ynm);
    ynm = (yplot./mean(meas.y));   
    rms_mv(i) = rms(ynm);
    XXX(i).rms_mv = rms_mv(i); 
    XXX(i).std_mv = sqrt(XXX(i).rms_mv);
    XXX(i).ynm = ynm;     
end
LB_rms = rms_mv; 
LB_rms_median=median(LB_rms);
LB_rms_mean=mean(LB_rms);

%% Si - 
clear j rms_mv
j = 1:54;

for i = 1:length(j)
    jj = j(i);
    strname = sprintf('OSC_ecoli_noaptes_%i',jj);
    load(strname);
    XXX(i).t_start = min(meas.t);%data(jj).t);
    XXX(i).t_end = max(meas.t);%data(jj).t);
    XXX(i).y = meas.y;
    XXX(i).drum_label = jj;
    
    ydat = XXX(i).y;
    P = polyfit(meas.t,meas.y,1);
    yplot = meas.y  - P(1)*meas.t - P(2);
    ynm = (yplot./mean(meas.y));    
    rms_mv(i) = rms(ynm);
    XXX(i).rms_mv = rms_mv(i); 
    XXX(i).std_mv = sqrt(XXX(i).rms_mv);
    XXX(i).ynm = ynm;     
end
Si_rms = rms_mv; 
Si_rms_median=median(Si_rms);

%1hour after exp.:
clear j rms_mv
j = 1:55;

for i = 1:length(j)
    jj = j(i);
    strname = sprintf('OSC_ecoli_noaptes_AMP_%i',jj);
    load(strname);
    XXX(i).t_start = min(meas.t);%data(jj).t);
    XXX(i).t_end = max(meas.t);%data(jj).t);
    XXX(i).y = meas.y;
    ydat = XXX(i).y;
       P = polyfit(meas.t,meas.y,1);
    yplot = meas.y  - P(1)*meas.t - P(2);
    ynm = (yplot./mean(meas.y)); 
    rms_mv(i) = rms(ynm);
    XXX(i).rms_mv = rms_mv(i); 
    XXX(i).std_mv = sqrt(XXX(i).rms_mv);
    XXX(i).ynm = ynm;     
end
Si_rms_cm = rms_mv;
Si_rms_cm_median=median(Si_rms_cm);

%% Si+
clear j rms_mv
j = 1:67;

for i = 1:length(j)
    jj = j(i);
    strname = sprintf('OSC_Ecoli_silicon_%i',jj);
    load(strname);
    XXX(i).t_start = min(meas.t);%data(jj).t);
    XXX(i).t_end = max(meas.t);%data(jj).t);
    XXX(i).y = meas.y;
    ydat = XXX(i).y;
     P = polyfit(meas.t,meas.y,1);
    yplot = meas.y  - P(1)*meas.t - P(2);
    ynm = (yplot./mean(meas.y)); 
    rms_mv(i) = rms(ynm);
    XXX(i).rms_mv = rms_mv(i); 
    XXX(i).std_mv = sqrt(XXX(i).rms_mv);
    XXX(i).ynm = ynm;     
end
Si_apt_rms = rms_mv; 
Si_apt_rms_median=median(Si_apt_rms);

%1hour after exp.:
%taking only the measurement points that show bacterial motion
clear j rms_mv
j = [1:6,8,9,11,12,14,15,17,18,20,26,28:33,36:60];

for i = 1:length(j)
    jj = j(i);
    strname = sprintf('OSC_ecoli_7740_silicon_CM_%i',jj);
    load(strname);
    XXX(i).t_start = min(meas.t);%data(jj).t);
    XXX(i).t_end = max(meas.t);%data(jj).t);
    XXX(i).y = meas.y;
    XXX(i).drum_label = jj;
    
    ydat = XXX(i).y;
       P = polyfit(meas.t,meas.y,1);
    yplot = meas.y  - P(1)*meas.t - P(2);
    ynm = (yplot./mean(meas.y));  
    rms_mv(i) = rms(ynm);
    XXX(i).rms_mv = rms_mv(i); 
    XXX(i).std_mv = sqrt(XXX(i).rms_mv);
    XXX(i).ynm = ynm;     
end
%taking into account the different laser powers
Si_apt_rms_cm = rms_mv*(2/3.5); 
Si_apt_rms_cm_median=median(Si_apt_rms_cm);

%% sio2 -
clear j rms_mv
j = 1:49;

for i = 1:length(j)
    jj = j(i);
    strname = sprintf('OSC_Ecoli_nopates_%i',jj);
    load(strname);
    XXX(i).t_start = min(meas.t);%data(jj).t);
    XXX(i).t_end = max(meas.t);%data(jj).t);
    XXX(i).y = meas.y;
    XXX(i).drum_label = jj;
    
    ydat = XXX(i).y;
       P = polyfit(meas.t,meas.y,1);
    yplot = meas.y  - P(1)*meas.t - P(2);
    ynm = (yplot./mean(meas.y)); 
    rms_mv(i) = rms(ynm);
    XXX(i).rms_mv = rms_mv(i); 
    XXX(i).std_mv = sqrt(XXX(i).rms_mv);
    XXX(i).ynm = ynm;     
end
Sio2_rms = rms_mv; 
Sio2_rms_median=median(Sio2_rms);

%1hour after exp.:
clear j rms_mv
j = 1:49;

for i = 1:length(j)
    jj = j(i);
    strname = sprintf('OSC_Ecoli_nopates_amp_drum_%i',jj);
    load(strname);
    XXX(i).t_start = min(meas.t);%data(jj).t);
    XXX(i).t_end = max(meas.t);%data(jj).t);
    XXX(i).y = meas.y;
    XXX(i).drum_label = jj;
    
    ydat = XXX(i).y;
       P = polyfit(meas.t,meas.y,1);
    yplot = meas.y  - P(1)*meas.t - P(2);
    ynm = (yplot./mean(meas.y)); 
    rms_mv(i) = rms(ynm);
    XXX(i).rms_mv = rms_mv(i); 
    XXX(i).std_mv = sqrt(XXX(i).rms_mv);
    XXX(i).ynm = ynm;     
end
Sio2_rms_cm = rms_mv; 
Sio2_rms_cm_median=median(Sio2_rms_cm);

%% Sio2+
clear j rms_mv
j = [1:20,24:27,29:30,32:40,45,46,48,51];

for i = 1:length(j)
    jj = j(i);
    strname = sprintf('OSC_Ecoli%i',jj);
    load(strname);
    XXX(i).t_start = min(meas.t);%data(jj).t);
    XXX(i).t_end = max(meas.t);%data(jj).t);
    XXX(i).y = meas.y;
    XXX(i).drum_label = jj;
    
    ydat = XXX(i).y;
       P = polyfit(meas.t,meas.y,1);
    yplot = meas.y  - P(1)*meas.t - P(2);
    ynm = (yplot./mean(meas.y));  
    rms_mv(i) = rms(ynm);
    XXX(i).rms_mv = rms_mv(i); 
    XXX(i).std_mv = sqrt(XXX(i).rms_mv);
    XXX(i).ynm = ynm;     
end
Sio2_apt_rms =rms_mv; 
Sio2_apt_rms_median=median(Sio2_apt_rms);

clear j rms_mv
%the duplicate:
j=[2:5,7:12,14:18,19:25];
for i = 1:length(j)
    jj = j(i);
    strname = sprintf('OSC_ecoli_7740_silicon_cav_aptes_A_%i',jj);
    load(strname);
    XXX(i).t_start = min(meas.t);%data(jj).t);
    XXX(i).t_end = max(meas.t);%data(jj).t);
    XXX(i).y = meas.y;
    XXX(i).drum_label = jj;
    
    ydat = XXX(i).y;
      P = polyfit(meas.t,meas.y,1);
    yplot = meas.y  - P(1)*meas.t - P(2);
    ynm = (yplot./mean(meas.y)); 
    rms_mv(i) = rms(ynm);
    XXX(i).rms_mv = rms_mv(i); 
    XXX(i).std_mv = sqrt(XXX(i).rms_mv);
    XXX(i).ynm = ynm;     
end
Sio2_apt_rms_B = rms_mv; 
Sio2_apt_rms_median_B=median(Sio2_apt_rms_B);
% total of both measurements
Sio2_apt_rms=[Sio2_apt_rms,Sio2_apt_rms_B];
Sio2apt_rms_median=median(Sio2_apt_rms);

%after exposure
clear j clear rms_mv
j = 1:25;

for i = 1:length(j)
    jj = j(i);
    strname = sprintf('OSC_ecoli_7740_silicon_cav_aptes_A_CM_%i',jj);
    load(strname);
    XXX(i).t_start = min(meas.t);%data(jj).t);
    XXX(i).t_end = max(meas.t);%data(jj).t);
    XXX(i).y = meas.y;
    XXX(i).drum_label = jj;
    
    ydat = XXX(i).y;
       P = polyfit(meas.t,meas.y,1);
    yplot = meas.y  - P(1)*meas.t - P(2);
    ynm = (yplot./mean(meas.y)); 
    rms_mv(i) = rms(ynm);
    XXX(i).rms_mv = rms_mv(i); 
    XXX(i).std_mv = sqrt(XXX(i).rms_mv);
    XXX(i).ynm = ynm;     
end
Sio2_apt_cm_rms = rms_mv; 
Sio2_apt_cm_rms_median=median(Sio2_apt_cm_rms);

%% graphene
clear j rms_mv
load cadData.mat;
j=1:60;
for i = 1:length(j)
    y=table2array(temp(i,1));
    y=cell2mat(y);
    t=linspace(0,30,1e5);
       P = polyfit(t,y,1);
    yplot = y  - P(1)*t - P(2);
    ynm = (yplot./mean(y)); 
    rms_mv(i) = rms(ynm);    
end
gra_rms = rms_mv*2; %rms in v *2 for laser power
gra_rms_median=median(gra_rms);

clear j rms_mv
load cadData.mat;
j=61:94;
for i = 1:length(j)
    jj = j(i);
    meas.y=table2array(temp(i,1));
    meas.y=cell2mat(meas.y);
      P = polyfit(meas.t,meas.y,1);
    yplot = meas.y  - P(1)*meas.t - P(2);
    ynm = (yplot./mean(meas.y)); 
    rms_mv(i) = rms(ynm);    
end
gra_rms_cm = rms_mv*2; %rms in v *2 for laser power
gra_rms_cm_median=median(gra_rms_cm);


%% calculating the SNR 
%mean of SNR
SNR_si_median=20*log10(Si_rms_median/LB_rms_median);
SNR_si_apt_median=20*log10(Si_apt_rms_median/LB_rms_median);
SNR_sio2_median=20*log10(Sio2_rms_median/LB_rms_median);
SNR_sio2_apt_median=20*log10(Sio2_apt_rms_median/LB_rms_median);
SNR_gra_median=20*log10(gra_rms_median/LB_rms_median);

%mean of SNR after antibiotics
SNR_si_cm_median=20*log10(Si_rms_cm_median/LB_rms_median);
SNR_si_apt_cm_median=20*log10(Si_apt_rms_cm_median/LB_rms_median);
SNR_sio2_cm_median=20*log10(Sio2_rms_cm_median/LB_rms_median);
SNR_sio2_cm_apt_median=20*log10(Sio2_apt_cm_rms_median/LB_rms_median);
SNR_gra_cm_median=20*log10(gra_rms_cm_median/LB_rms_median);
%SNR
SNR_si=20*log10(Si_rms./LB_rms_median);
SNR_si_apt=20*log10(Si_apt_rms./LB_rms_median);
SNR_sio2=20*log10(Sio2_rms./LB_rms_median);
SNR_sio2_apt=20*log10(Sio2_apt_rms./LB_rms_median);
SNR_gra=20*log10(gra_rms./LB_rms_median);
%SNR after antibiotics
SNR_si_CM=20*log10(Si_rms_cm./LB_rms_median);
SNR_si_apt_CM=20*log10(Si_apt_rms_cm./LB_rms_median);
SNR_sio2_CM=20*log10(Sio2_rms_cm./LB_rms_median);
SNR_sio2_apt_CM=20*log10(Sio2_apt_cm_rms./LB_rms_median);
SNR_gra_CM=20*log10(gra_rms_cm./LB_rms_median);
%% plotting it all together
figure(1)
y=[SNR_gra,SNR_sio2_apt,SNR_sio2,SNR_si_apt,SNR_si];
g=[
    repmat({'DLG drums'}, length(SNR_gra),1); ...
    repmat({'Si well+'}, length(SNR_sio2_apt),1); ...
     repmat({'Si well'}, length(SNR_sio2),1);...
    repmat({'Si+'}, length(SNR_si_apt),1);...
     repmat({'Si'}, length(SNR_si),1)];
boxplot(y,g,'BoxStyle','filled','Plotstyle','traditional','LabelOrientation','inline'); 
ylabel('SNR (dB)')
title('Boxplot of SNR of E.coli 7740')
grid on
hold on

% yline(4,'r')
% ylim([200 1000])

%% tyring the not boxplot
% figure
% notBoxPlot(SNR_gra,1)
% hold on
% notBoxPlot(SNR_sio2_apt,2)
% notBoxPlot(SNR_sio2,3)
% notBoxPlot(SNR_si_apt,4)
% notBoxPlot(SNR_si,5)
% ylim([0 60])
% ylabel('SNR (dB)')
% title('Boxplot of SNR of E.coli 7740')
% S1=load('gra.mat');
% S1=S1.SNR_gra';
% S2=load('sio2_apt.mat');
% S2=S2.SNR_sio2_apt';
% S3=load('sio2.mat');
% S3=S3.SNR_sio2';
% S4=load('si_apt.mat');
% S4=S4.SNR_si_apt';
% S5=load('si.mat');
% S5=S5.SNR_si';
% a=xlswrite('spreadsheet1.xlsx',S1);
% a=xlswrite('spreadsheet2.xlsx',S2);
% a=xlswrite('spreadsheet3.xlsx',S3);
% a=xlswrite('spreadsheet4.xlsx',S4);
% a=xlswrite('spreadsheet5.xlsx',S5);

%%

% figure(2)
% h1=histfit(SNR_sio2_apt,10,'lognormal','Normalization','probability')
% h1(1).FaceColor = 'b';%(1) is histogram
% h1(1).FaceAlpha=0.25; 
% h1(2).Color = 'b'; %(2) is fit
% hold on
% h2=histfit(abs(SNR_sio2_apt_CM),10,'lognormal','Normalization','probability')
% h2(1).FaceColor = 'r';
% h2(2).Color = 'r';
% h2(1).FaceAlpha=0.5;
% title('Histogram of SNR \sigma of E.coli 7740 + APTES')
% xlabel('SNR (db)')
% ylabel('Probability')
% legend('7740','Lognormal fit','+ CM','Lognormal fit')
% N1=sum(h1(1).YData);
% N2=sum(h2(1).YData);
% h1(1).YData=h1(1).YData/N1;
% h1(2).YData=h1(2).YData/N1;
% h2(1).YData=h2(1).YData/N2;
% h2(2).YData=h2(2).YData/N2;
% xlim([0 60])
% ylim([0 1])

% figure(2)
% histogram(SNR_sio2_apt,10)
% % h1(1).FaceColor = 'b';%(1) is histogram
% % h1(1).FaceAlpha=0.25; 
% % h1(2).Color = 'b'; %(2) is fit
% hold on
% histogram(SNR_sio2_apt_CM,10)
% % h2(1).FaceColor = 'r';
% % h2(2).Color = 'r';
% % h2(1).FaceAlpha=0.5;
% title('Histogram of SNR of E.coli 7740 + APTES')
% xlabel('SNR (db)')
% ylabel('Probability')
% % legend('7740','Lognormal fit','+ CM','Lognormal fit')
% % N1=sum(h1.YData);
% % N2=sum(h2.YData);
% % h1.YData=h1.YData/N1;
% % % h1(2).YData=h1(2).YData/N1;
% % h2.YData=h2.YData/N2;
% % h2(2).YData=h2(2).YData/N2;

%% the 4 histograms
figure(4)
set(gca,'FontSize',20);
subplot(2,2,1)
h1=histogram(SNR_sio2_apt,10,'Normalization','probability')
% h1.FaceColor = 'b';%(1) is histogram
% h1.FaceAlpha=0.25; 
xlabel('SNR (dB)','FontSize',20);
ylabel('Probability','FontSize',20);
% title('Si/SiO_2 +','FontSize',20)
% legend('7740','Lognormal fit','+ CM','Lognormal fit')
hold on 
h2=histogram(SNR_sio2_apt_CM,10,'Normalization','probability')
% h2.FaceColor = 'r';
% h2.FaceAlpha=0.5;
xlim([0 40])
ylim([0 0.4])
grid on
legend('7740','+CM')
set(gca,'FontSize',20)
subplot(2,2,2)
histogram(SNR_sio2,10,'Normalization','probability')
xlabel('SNR (dB)','FontSize',20);
ylabel('Probability','FontSize',20);
% title('Si/Sio_2 -','FontSize',20)
hold on 
histogram(SNR_sio2_CM,10,'Normalization','probability')
xlim([0 40])
ylim([0 0.4])
legend('7740','+CM')
grid on
set(gca,'FontSize',20)
subplot(2,2,3)
histogram(SNR_si_apt,10,'Normalization','probability')
xlabel('SNR (dB)','FontSize',20);
ylabel('Probability','FontSize',20);
% title('Si +','FontSize',20)
hold on 
histogram(SNR_si_apt_CM,10,'Normalization','probability')
xlim([0 40])
ylim([0 0.4])
legend('7740','+CM')
grid on
set(gca,'FontSize',20)
subplot(2,2,4)
histogram(SNR_si,10,'Normalization','probability')
hold on 
histogram(SNR_si_CM,10,'Normalization','probability')
xlim([0 40])
ylim([0 0.4])
legend('7740','+CM')
grid on
xlabel('SNR (dB)','FontSize',20);
ylabel('Probability','FontSize',20);
% title('Si -','FontSize',20)
set(gca,'FontSize',20)

%% staticstics
[hh1,pp1,~]=ranksum(SNR_si,SNR_si_CM); % si no apt
[hh2,pp2,~]=ranksum(SNR_si_apt,SNR_si_apt_CM); %si
[hh3,pp3,~]=ranksum(SNR_sio2_apt,SNR_sio2_apt_CM); %cav apt
[hh4,pp4,~]=ranksum(SNR_sio2,SNR_sio2_CM); % cav no apt
[hh5,pp5,~]=ranksum(SNR_gra,SNR_gra_CM); %gra


% test1=signrank(SNR_si,SNR_si_CM)
% test2=signrank(SNR_si_apt,SNR_si_apt_CM)