function Batch_growth_without_inhibition_2
clear all 

% Name global parameters
global K_s a_s0 m_s0 c_x0 c_s0 c_p0 mu_max0 c_p_crit_mu beta_a beta_m q_s_max0 D gamma_x gamma_s gamma_p;
       
% Parameters
K_s = 0.5;              % (g_s/L)
mu_max0 = 0.48;         % (h-1)
m_s0 = 2;               % (g_s/g_x h) 
a_s0 = 19;              % (g_s/g_x)
c_p_crit_mu = 72;       % (g/L)

% conversion g to mol 
nu_H = 1.73;            % stoichiometic coefficient H in biomass
nu_O = 0.41;            % stoichiometic coefficient O in biomass
nu_N = 0.23;            % stoichiometic coefficient N in biomass

MW_x = 12 + nu_H + 16*nu_O + 14*nu_N;   % (g/mol_x)
MW_s = 180;                             % (g/mol_s)
MW_p = 46;                              % (g/mol_p)

K_s = K_s/MW_s;                         % (mol_s/L)
a_s0 = a_s0*MW_x/MW_s;                  % (mol_s/mol_x)
m_s0 = m_s0*MW_x/MW_s;                  % (mol_s/(mol_x h))
beta_a = 2700*MW_p;                     % (mol_p/L)
beta_m = 154/MW_p;                      % (mol_p/L)
c_p_crit_mu = c_p_crit_mu/MW_p;         % (mol_p/L)

gamma_x = 4 + nu_H + nu_O*(-2) + nu_N*(-3);
gamma_s = 24;
gamma_p = 12;

D = 0;                                  % Dilution rate (1/h)

q_s_max0 = -mu_max0 *a_s0 - m_s0;

%% ODE Solver
% set time interval (h) 
tini=0; tend = 18.89; 
tspan = [tini tend];
    
% set initial condition (values at t=0)
c_x0 = 0.001;   % (mol_x/L)
c_s0 = 0.54722; % (mol/L);
c_p0 = 0;
y0 = [c_x0; c_s0; c_p0]; % Construct initial vector
% name function of ODE system
sys = @(t,y) dydt(t,y);
% set tolerances and solve ODE system (t0= 0)
options = odeset('RelTol',1e-10, 'AbsTol',1e-10);
[t,y]=ode15s(sys,tspan,y0,options);

%% Calculate rates for plotting
%{ 
From here on until the end of the first function, all calculations are done for plotting reasons. 
To see the actual ODE system code, please refer to the second funcion 'dy=dydt(~,y)'
%}
c_x = y(:,1); c_s = y(:,2); c_p = y(:,3);  % Rename unknowns 

%% Specific rates - Growth, Consumption and Formation for plotting - inhibition terms in comments
a_s = a_s0;      %*(1 + c_p/beta_a);   % Pirt coefficient (mol_s/mol_x) 
m_s = m_s0;      %*(1 + c_p/beta_m);   % Specific maintenance rate (mol_s/mol_x/h)
mu_max = mu_max0; %*(1 - c_p/c_p_crit_mu); 

q_s_max = -a_s.*mu_max - m_s;       % Maximum specific substrate uptake rate (mol_s/mol_x/h)
q_s = q_s_max.*(c_s./(K_s + c_s));  % Specific substrate uptake rate (mol_s/mol_x/h)
mu = (-q_s - m_s)./a_s;             % Specific growth rate (1/h) from Pirt equation
q_p = (mu*gamma_x + q_s*gamma_s)/(-gamma_p) ; % Degree of reduction balance; shortcut to solve elemental balances

    %% Plot results 

    % Glucose and ethanol
figure('Name','Straathof2022','NumberTitle','off'); set(gcf,'color','w');
subplot(3,2,2); xlabel('Time (h)');axis([0 inf 0 inf]);
yyaxis left; plot(t, c_s,'k', 'LineWidth',2), 'o'; set(gca,'FontSize',10,'YColor','k');  
ylabel('c_{glucose} (mol/L)'); 
yyaxis right; plot(t, c_p,'b--','LineWidth',2); set(gca,'FontSize',10,'YColor','k');
ylabel('c_{ethanol} (mol/L)'); 
legend('glucose','ethanol');

 % Biomass
subplot(3,2,1); xlabel('Time (h)'); axis([0 inf 0 inf]);
yyaxis left; plot(t,y(:,1),'b--','LineWidth',2); set(gca,'FontSize',10,'YColor','k');
ylabel('c_{x} (mol/L)');
legend('biomass');

    % Growth rate
subplot(3,2,3); xlabel('Time (h)'); axis([0 inf 0 inf]);
yyaxis left; plot(t, mu, 'b--','LineWidth',2); set(gca,'FontSize',10,'YColor','k');
ylabel('mu (h^{-1})');
legend('Specific growth rate');

    % Substrate uptake rate
subplot(3,2,4); xlabel('Time (h)'); axis([0 inf 0 inf]);
yyaxis left; plot(t, -q_s, 'b--','LineWidth',2); set(gca,'FontSize',10,'YColor','k');
ylabel('-q_{s} (mol_{s} mol_{x}^{-1} h^{-1})');
legend('Specific substrate uptake rate');

    % Maximum growth rate
subplot(3,2,5); xlabel('Time (h)'); axis([0 inf 0 inf]);
yyaxis left; plot(t, mu_max, 'b--','LineWidth',2); set(gca,'FontSize',10,'YColor','k');
ylabel('mu^{max} (h^{-1})');
legend('Maximum specific growth rate');

    % Maximum substrate uptake rate
subplot(3,2,6); xlabel('Time (h)'); axis([0 inf 0 inf]);
yyaxis left; plot(t, -q_s_max, 'b--','LineWidth',2); set(gca,'FontSize',10,'YColor','k');
ylabel('-q_{s}^{max} (mol_{s} mol_{x}^{-1} h^{-1})');
legend('Maximum specific substrate uptake rate');
%% Export results to excel 
xlswrite('Batch growth without inhibition.xlsx',[t,y]); % Exports raw data

end
%% Second function - System of equations
%{
This second function includes:
    (1) Dynamic thermodynamic state analysis calculation
    (2) Kinetic rates definition
    (3) ODE system of equations (mass balances)
%}
function dy=dydt(~,y) 
% Rename unknowns
c_x = y(1); c_s = y(2); c_p = y(3);  
% Parameters - Global
global K_s a_s0 m_s0 c_x0 c_s0 c_p0 mu_max0 c_p_crit_mu beta_a beta_m q_s_max0 D gamma_x gamma_s gamma_p;
       

% Parameters - Local

%% Inhibition terms in comments
a_s = a_s0; %.*(1 + c_p/beta_a);   % Pirt coefficient (mol_s/mol_x) 
m_s = m_s0; %.*(1 + c_p/beta_m);   % Specific maintenance rate (mol_s/mol_x/h)
mu_max = mu_max0; %.*(1 - c_p/c_p_crit_mu); 

%% Specific rates - Growth, Consumption and Formation
q_s_max = -a_s.*mu_max - m_s;       % Maximum specific substrate uptake rate (mol_s/mol_x/h)
q_s = q_s_max.*(c_s./(K_s + c_s));  % Specific substrate uptake rate (mol_s/mol_x/h)
mu = (-q_s - m_s)./a_s;             % Specific growth rate (1/h) from Pirt equation
q_p = (mu*gamma_x + q_s*gamma_s)/(-gamma_p) ; % Degree of reduction balance; shortcut to solve elemental balances

%% Biological volume-specific rates (mol_i/m3/h)
r_x = mu.*c_x;  % Biomass production rate 
r_s = q_s.*c_x; % Glucose production rate
r_p = q_p.*c_x; % Ethanol production rate

%% Calculate derivatives
dy(1) = r_x + D.*(c_x0 - c_x); 
dy(2) = r_s + D.*(c_s0 - c_s);
dy(3) = r_p + D.*(c_p0 - c_p);
dy=dy';
end