#ifndef MLNODE_HH
#define MLNODE_HH

using namespace std;

class MLNode {

    public:
        // Public constructor
        MLNode();
        // Public constructor with features/arguments
        MLNode(vector<int> assigned, int domain_size, long degree, int val_order, int position, int value, int val_pos, 
               int min_val_dom, int max_val_dom, int regret_min, int regret_max);
        // Retrieves the parent of the node
        MLNode* getParent();
        // Checks whether the node has a parent
        bool hasParent();
        // Checks whether this node is a leaf
        bool isLeaf();
        // Checks position in the tree (starting at 0 in the root)
        int getPositionInTree();
        void setPositionInTree(int tree_pos);
        // Retrieves the set of children nodes of this node
        vector<MLNode*> getChildren();
        // Sets a node as parent and adds the node to the children set of the parent
        void setParent(MLNode* parent);
        // Pushes the passed node as a child to the set of children nodes
        void pushChild(MLNode* child);
        // Link parent to a child in one step using setParent and pushChild
        void linkChildToParent(MLNode* parent);
        // Get a child node based on it's assigned value
        MLNode* getChildByValue(int value);

        // Retrieves the assigned values up to this node
        vector<int> getAssigned();

        // ---------------------
        // Features of this node
        // ---------------------
        int getDomainSize();
        long getDegree();
        int getVarOrder();
        int getPosition();
        int getValue();
        int getValuePosition();
        int getMinValDom();
        int getMaxValDom();
        int getRegretMin();
        int getRegretMax();

        // Node score (based on features and function that is being learned)
        double getNodeScore();
        void setNodeScore(double score);

    private:
        MLNode* parent;
        vector<MLNode*> children;
        bool is_leaf;
        int position_in_tree;

        // Stores assignments used to lookup where we are in the search tree
        vector<int> assigned;

        // ---------------------
        // Features of this node
        // ---------------------
        int domain_size;
        long degree;
        int var_order;
        int position;
        int value;
        int value_position;
        int min_value_domain;
        int max_value_domain;
        int regret_min;
        int regret_max;
        int second_to_last_min_value_domain;

        // Node score
        double node_score;
};

#endif