%
% Inertial effects in sedimenting ssuspensions of solid spheres
% in a liquid - Tariq Shajahan, Wim-Paul Breugem 
% *(W.P.Breugem@tudelft.nl) 
% International Journal of Multiphase Flow
%
% Laboratory for Aero & Hydrodynamics,
% Process & Energy Department
% Delft University of Technology
% Mekelweg 2, 2628 CD, Delft
% Netherlands
%
clc;clear;close all

%
% Load data
%

% Load settling velocities
Ws144 = load('Fig5_Ws144.txt');
Ws178 = load('Fig5_Ws178.txt');
Ws210 = load('Fig5_Ws210.txt');

% Load RMS fluid stats
fRMS144 = load('Fig6_fRMS_Ga144.txt');
fRMS178 = load('Fig6_fRMS_Ga178.txt');
fRMS210 = load('Fig6_fRMS_Ga210.txt');

% Load RMS solid stats
sRMS144 = load('Fig6_sRMS_Ga144.txt');
sRMS178 = load('Fig6_sRMS_Ga178.txt');
sRMS210 = load('Fig6_sRMS_Ga210.txt');

% Load mean fluid stats
fMean144 = load('Fig7_fMean_Ga144.txt');
fMean178 = load('Fig7_fMean_Ga178.txt');
fMean210 = load('Fig7_fMean_Ga210.txt');

% Load mean solid stats
sMean144 = load('Fig7_sMean_Ga144.txt');
sMean178 = load('Fig7_sMean_Ga178.txt');
sMean210 = load('Fig7_sMean_Ga210.txt');

% Load particle velocity pdfs
Fig8a_Ga210_pdf_CaseJ = load('Fig8a_CaseJ.txt'); % 2%
Fig8a_Ga210_pdf_CaseA = load('Fig8a_CaseA.txt'); % 2%
Fig8a_Ga210_pdf_CaseH = load('Fig8a_CaseH.txt'); % 4%
Fig8a_Ga210_pdf_CaseB = load('Fig8a_CaseB.txt'); % 6%
Fig8a_Ga210_pdf_CaseI = load('Fig8a_CaseI.txt'); % 8%
Fig8a_Ga210_pdf_CaseC = load('Fig8a_CaseC.txt'); % 10%
Fig8a_Ga210_pdf_CaseG = load('Fig8a_CaseG.txt'); % 15%
Fig8a_Ga210_pdf_CaseD = load('Fig8a_CaseD.txt'); % 20%
Fig8a_Ga210_pdf_CaseE = load('Fig8a_CaseE.txt'); % 25%
Fig8a_Ga210_pdf_CaseF = load('Fig8a_CaseF.txt'); % 30%

Fig8b_Ga210_pdf_CaseJ = load('Fig8b_CaseJ.txt'); % 2%
Fig8b_Ga210_pdf_CaseA = load('Fig8b_CaseA.txt'); % 2%
Fig8b_Ga210_pdf_CaseH = load('Fig8b_CaseH.txt'); % 4%
Fig8b_Ga210_pdf_CaseB = load('Fig8b_CaseB.txt'); % 6%
Fig8b_Ga210_pdf_CaseI = load('Fig8b_CaseI.txt'); % 8%
Fig8b_Ga210_pdf_CaseC = load('Fig8b_CaseC.txt'); % 10%
Fig8b_Ga210_pdf_CaseG = load('Fig8b_CaseG.txt'); % 15%
Fig8b_Ga210_pdf_CaseD = load('Fig8b_CaseD.txt'); % 20%
Fig8b_Ga210_pdf_CaseE = load('Fig8b_CaseE.txt'); % 25%
Fig8b_Ga210_pdf_CaseF = load('Fig8b_CaseF.txt'); % 30%

Fig8c_Ga210_pdf_CaseA = load('Fig8c_CaseA.txt'); % 2%
Fig8c_Ga210_pdf_CaseH = load('Fig8c_CaseH.txt'); % 4%
Fig8c_Ga210_pdf_CaseB = load('Fig8c_CaseB.txt'); % 6%
Fig8c_Ga210_pdf_CaseI = load('Fig8c_CaseI.txt'); % 8%
Fig8c_Ga210_pdf_CaseC = load('Fig8c_CaseC.txt'); % 10%
Fig8c_Ga210_pdf_CaseG = load('Fig8c_CaseG.txt'); % 15%
Fig8c_Ga210_pdf_CaseD = load('Fig8c_CaseD.txt'); % 20%
Fig8c_Ga210_pdf_CaseE = load('Fig8c_CaseE.txt'); % 25%
Fig8c_Ga210_pdf_CaseF = load('Fig8c_CaseF.txt'); % 30%

Fig8d_Ga210_pdf_CaseA = load('Fig8d_CaseA.txt'); % 2%
Fig8d_Ga210_pdf_CaseH = load('Fig8d_CaseH.txt'); % 4%
Fig8d_Ga210_pdf_CaseB = load('Fig8d_CaseB.txt'); % 6%
Fig8d_Ga210_pdf_CaseI = load('Fig8d_CaseI.txt'); % 8%
Fig8d_Ga210_pdf_CaseC = load('Fig8d_CaseC.txt'); % 10%
Fig8d_Ga210_pdf_CaseG = load('Fig8d_CaseG.txt'); % 15%
Fig8d_Ga210_pdf_CaseD = load('Fig8d_CaseD.txt'); % 20%
Fig8d_Ga210_pdf_CaseE = load('Fig8d_CaseE.txt'); % 25%
Fig8d_Ga210_pdf_CaseF = load('Fig8d_CaseF.txt'); % 30%

Fig8e_Ga210_pdf_CaseA = load('Fig8e_CaseA.txt'); % 2%
Fig8e_Ga210_pdf_CaseB = load('Fig8e_CaseB.txt'); % 6%
Fig8e_Ga210_pdf_CaseC = load('Fig8e_CaseC.txt'); % 10%
Fig8e_Ga210_pdf_CaseD = load('Fig8e_CaseD.txt'); % 20%
Fig8e_Ga210_pdf_CaseE = load('Fig8e_CaseE.txt'); % 25%
Fig8e_Ga210_pdf_CaseF = load('Fig8e_CaseF.txt'); % 30%

Fig8f_Ga210_pdf_CaseA = load('Fig8f_CaseA.txt'); % 2%
Fig8f_Ga210_pdf_CaseB = load('Fig8f_CaseB.txt'); % 6%
Fig8f_Ga210_pdf_CaseC = load('Fig8f_CaseC.txt'); % 10%
Fig8f_Ga210_pdf_CaseD = load('Fig8f_CaseD.txt'); % 20%
Fig8f_Ga210_pdf_CaseE = load('Fig8f_CaseE.txt'); % 25%
Fig8f_Ga210_pdf_CaseF = load('Fig8f_CaseF.txt'); % 30%

% Load autocorrelation data

% Ga 144
Fig9_Ga144_CaseA = load('Fig9_Ga144_CaseA_Acorr_equidistant.txt');
Fig9_Ga144_CaseB = load('Fig9_Ga144_CaseB_Acorr_equidistant.txt');
Fig9_Ga144_CaseC = load('Fig9_Ga144_CaseC_Acorr_equidistant.txt');
Fig9_Ga144_CaseD = load('Fig9_Ga144_CaseD_Acorr_equidistant.txt');
Fig9_Ga144_CaseE = load('Fig9_Ga144_CaseE_Acorr_equidistant.txt');
Fig9_Ga144_CaseF = load('Fig9_Ga144_CaseF_Acorr_equidistant.txt');
Fig9_Ga144_CaseG = load('Fig9_Ga144_CaseG_Acorr_equidistant.txt');
Fig9_Ga144_CaseH = load('Fig9_Ga144_CaseH_Acorr_equidistant.txt');
Fig9_Ga144_CaseI = load('Fig9_Ga144_CaseI_Acorr_equidistant.txt');
Fig9_Ga144_CaseJ = load('Fig9_Ga144_CaseJ_Acorr_equidistant.txt');

% Ga 178
Fig9_Ga178_CaseA = load('Fig9_Ga178_CaseA_Acorr_equidistant.txt');
Fig9_Ga178_CaseB = load('Fig9_Ga178_CaseB_Acorr_equidistant.txt');
Fig9_Ga178_CaseC = load('Fig9_Ga178_CaseC_Acorr_equidistant.txt');
Fig9_Ga178_CaseD = load('Fig9_Ga178_CaseD_Acorr_equidistant.txt');
Fig9_Ga178_CaseE = load('Fig9_Ga178_CaseE_Acorr_equidistant.txt');
Fig9_Ga178_CaseF = load('Fig9_Ga178_CaseF_Acorr_equidistant.txt');
Fig9_Ga178_CaseG = load('Fig9_Ga178_CaseG_Acorr_equidistant.txt');
Fig9_Ga178_CaseH = load('Fig9_Ga178_CaseH_Acorr_equidistant.txt');
Fig9_Ga178_CaseI = load('Fig9_Ga178_CaseI_Acorr_equidistant.txt');

% Ga210 
Fig9_Ga210_CaseA = load('Fig9_Ga210_CaseA_Acorr_equidistant.txt');
Fig9_Ga210_CaseB = load('Fig9_Ga210_CaseB_Acorr_equidistant.txt');
Fig9_Ga210_CaseC = load('Fig9_Ga210_CaseC_Acorr_equidistant.txt');
Fig9_Ga210_CaseD = load('Fig9_Ga210_CaseD_Acorr_equidistant.txt');
Fig9_Ga210_CaseE = load('Fig9_Ga210_CaseE_Acorr_equidistant.txt');
Fig9_Ga210_CaseF = load('Fig9_Ga210_CaseF_Acorr_equidistant.txt');

% Load integral time scale
Fig10_tau_Ga144 = load('Fig10_tau_Ga144.txt');
Fig10_tau_Ga178 = load('Fig10_tau_Ga178.txt');
Fig10_tau_Ga210 = load('Fig10_tau_Ga210.txt');

% Load cross-correlation data
% Ga 144
Fig11_Ga144_CaseA = load('Fig11_Ga144_CaseA_CrossCorr_normalized.txt');
Fig11_Ga144_CaseB = load('Fig11_Ga144_CaseB_CrossCorr_normalized.txt');
Fig11_Ga144_CaseC = load('Fig11_Ga144_CaseC_CrossCorr_normalized.txt');
Fig11_Ga144_CaseD = load('Fig11_Ga144_CaseD_CrossCorr_normalized.txt');
Fig11_Ga144_CaseE = load('Fig11_Ga144_CaseE_CrossCorr_normalized.txt');
Fig11_Ga144_CaseF = load('Fig11_Ga144_CaseF_CrossCorr_normalized.txt');
Fig11_Ga144_CaseG = load('Fig11_Ga144_CaseG_CrossCorr_normalized.txt');
Fig11_Ga144_CaseH = load('Fig11_Ga144_CaseH_CrossCorr_normalized.txt');
Fig11_Ga144_CaseI = load('Fig11_Ga144_CaseI_CrossCorr_normalized.txt');
Fig11_Ga144_CaseJ = load('Fig11_Ga144_CaseJ_CrossCorr_normalized.txt');
                          
% Ga 178
Fig11_Ga178_CaseA = load('Fig11_Ga178_CaseA_CrossCorr_normalized.txt');
Fig11_Ga178_CaseB = load('Fig11_Ga178_CaseB_CrossCorr_normalized.txt');
Fig11_Ga178_CaseC = load('Fig11_Ga178_CaseC_CrossCorr_normalized.txt');
Fig11_Ga178_CaseD = load('Fig11_Ga178_CaseD_CrossCorr_normalized.txt');
Fig11_Ga178_CaseE = load('Fig11_Ga178_CaseE_CrossCorr_normalized.txt');
Fig11_Ga178_CaseF = load('Fig11_Ga178_CaseF_CrossCorr_normalized.txt');
Fig11_Ga178_CaseG = load('Fig11_Ga178_CaseG_CrossCorr_normalized.txt');
Fig11_Ga178_CaseH = load('Fig11_Ga178_CaseH_CrossCorr_normalized.txt');
Fig11_Ga178_CaseI = load('Fig11_Ga178_CaseI_CrossCorr_normalized.txt');
                                     
% Ga210
Fig11_Ga210_CaseA = load('Fig11_Ga210_CaseA_CrossCorr_normalized.txt');
Fig11_Ga210_CaseB = load('Fig11_Ga210_CaseB_CrossCorr_normalized.txt');
Fig11_Ga210_CaseC = load('Fig11_Ga210_CaseC_CrossCorr_normalized.txt');
Fig11_Ga210_CaseD = load('Fig11_Ga210_CaseD_CrossCorr_normalized.txt');
Fig11_Ga210_CaseE = load('Fig11_Ga210_CaseE_CrossCorr_normalized.txt');
Fig11_Ga210_CaseF = load('Fig11_Ga210_CaseF_CrossCorr_normalized.txt');

% Load correlation coefficient
Ga144_CCoeff = load('Fig11_Ga144_CCoeff.txt');
Ga178_CCoeff = load('Fig11_Ga178_CCoeff.txt');
Ga210_CCoeff = load('Fig11_Ga210_CCoeff.txt');

% Load normalized frequency spectra
% Ga 144
Fig12_Ga144_CaseA = load('Fig12_Ga144_CaseA_spectra.txt');
Fig12_Ga144_CaseB = load('Fig12_Ga144_CaseB_spectra.txt');
Fig12_Ga144_CaseC = load('Fig12_Ga144_CaseC_spectra.txt');
Fig12_Ga144_CaseD = load('Fig12_Ga144_CaseD_spectra.txt');
Fig12_Ga144_CaseE = load('Fig12_Ga144_CaseE_spectra.txt');
Fig12_Ga144_CaseF = load('Fig12_Ga144_CaseF_spectra.txt');
Fig12_Ga144_CaseG = load('Fig12_Ga144_CaseG_spectra.txt');
Fig12_Ga144_CaseH = load('Fig12_Ga144_CaseH_spectra.txt');
Fig12_Ga144_CaseI = load('Fig12_Ga144_CaseI_spectra.txt');
Fig12_Ga144_CaseJ = load('Fig12_Ga144_CaseJ_spectra.txt');

% Ga 178
Fig12_Ga178_CaseA = load('Fig12_Ga178_CaseA_spectra.txt');
Fig12_Ga178_CaseB = load('Fig12_Ga178_CaseB_spectra.txt');
Fig12_Ga178_CaseC = load('Fig12_Ga178_CaseC_spectra.txt');
Fig12_Ga178_CaseD = load('Fig12_Ga178_CaseD_spectra.txt');
Fig12_Ga178_CaseE = load('Fig12_Ga178_CaseE_spectra.txt');
Fig12_Ga178_CaseF = load('Fig12_Ga178_CaseF_spectra.txt');
Fig12_Ga178_CaseG = load('Fig12_Ga178_CaseG_spectra.txt');
Fig12_Ga178_CaseH = load('Fig12_Ga178_CaseH_spectra.txt');
Fig12_Ga178_CaseI = load('Fig12_Ga178_CaseI_spectra.txt');

% Ga210 
Fig12_Ga210_CaseA = load('Fig12_Ga210_CaseA_spectra.txt');
Fig12_Ga210_CaseB = load('Fig12_Ga210_CaseB_spectra.txt');
Fig12_Ga210_CaseC = load('Fig12_Ga210_CaseC_spectra.txt');
Fig12_Ga210_CaseD = load('Fig12_Ga210_CaseD_spectra.txt');
Fig12_Ga210_CaseE = load('Fig12_Ga210_CaseE_spectra.txt');
Fig12_Ga210_CaseF = load('Fig12_Ga210_CaseF_spectra.txt');

% Load mean collision force data
Fig13a_Ga144_MF = load('Fig13a_MF_Ga144.txt');
Fig13a_Ga178_MF = load('Fig13a_MF_Ga178.txt');
Fig13a_Ga210_MF = load('Fig13a_MF_Ga210.txt');

% Load number of collision events
Fig13b_Ga144_RF = load('Fig13b_CE_Ga144.txt');
Fig13b_Ga178_RF = load('Fig13b_CE_Ga178.txt');
Fig13b_Ga210_RF = load('Fig13b_CE_Ga210.txt');

% Kinematic wave data
Fig15a_Ga144 = load('Fig15a_Ga144.txt');
Fig15a_Ga178 = load('Fig15a_Ga178.txt');
Fig15a_Ga210 = load('Fig15a_Ga210.txt');
Fig15a_Kynch_Ga144 = load('Fig15a_Kynch_Ga144.txt');
Fig15a_Kynch_Ga178 = load('Fig15a_Kynch_Ga178.txt');
Fig15a_Kynch_Ga210 = load('Fig15a_Kynch_Ga210.txt');

Fig15b_Ga144 = load('Fig15b_Ga144.txt');
Fig15b_Ga178 = load('Fig15b_Ga178.txt');
Fig15b_Ga210 = load('Fig15b_Ga210.txt');

% Load peak values in spectra and KW wave frequency
Fig16a_peakUWspectra = load('Fig16a_peakUWspectra.txt');
Fig16b_peakUWspectra = load('Fig16b_peakUWspectra.txt');
Fig16c_peakUWspectra = load('Fig16c_peakUWspectra.txt');

Fig16a_peakVspectra = load('Fig16a_peakVspectra.txt');
Fig16b_peakVspectra = load('Fig16b_peakVspectra.txt');
Fig16c_peakVspectra = load('Fig16c_peakVspectra.txt');

Fig16a_KWFreq = load('Fig16a_KWFreq.txt');
Fig16b_KWFreq = load('Fig16b_KWFreq.txt');
Fig16c_KWFreq = load('Fig16c_KWFreq.txt');

%
% Fig. 5
%
figure(1)
hold on
plot(log10(1.0-Ws144(1:end,1)),log10(abs(Ws144(1:end,2))),'o','MarkerSize',6.0,'MarkerFaceColor','red' ,'MarkerEdgeColor','k')
plot(log10(1.0-Ws178(1:end,1)),log10(abs(Ws178(1:end,2))),'s','MarkerSize',6.0,'MarkerFaceColor','blue','MarkerEdgeColor','k')
plot(log10(1.0-Ws210(1:end,1)),log10(abs(Ws210(1:end,2))),'^','MarkerSize',6.0,'MarkerFaceColor','green','MarkerEdgeColor','k')
plot(log10(1.0),log10(abs(-0.8882)),'o','MarkerSize',9.0,'MarkerFaceColor','black' ,'MarkerEdgeColor','w')
plot(log10(1.0),log10(abs(-0.9433)),'s','MarkerSize',9.0,'MarkerFaceColor','black','MarkerEdgeColor','w')
plot(log10(1.0),log10(abs(-0.9681)),'^','MarkerSize',9.0,'MarkerFaceColor','black','MarkerEdgeColor','w')
xlim([-0.2 0])
xR = xlim;
xR = linspace(xR(1),0,50);
yR1 = 2.997.*xR + -0.1206;  % Ga 144
yR2 = 2.852.*xR + -0.1071;  % Ga 178
yR3 = 2.921.*xR + -0.08167; % Ga 210
plot(xR,yR1,'--','color','black')
plot(xR,yR2,'--','color','black')
plot(xR,yR3,'--','color','black')
xlabel('log(1-$\phi$)')
ylabel('$log(|V_s|/\sqrt{gD_p})$')
legend('Ga=144','Ga=178','Ga=210','Location','NorthWest')
% Adding labels
p1 = '$2\%$';
text(log10(1.0-Ws210(1,1))-0.005,log10(abs(Ws210(1,2)))+0.05,p1)
p1 = '$6\%$';
text(log10(1.0-Ws210(2,1))-0.005,log10(abs(Ws210(2,2)))+0.05,p1)
p1 = '$10\%$';                   
text(log10(1.0-Ws210(3,1))-0.005,log10(abs(Ws210(3,2)))+0.05,p1)
p1 = '$20\%$';
text(log10(1.0-Ws210(4,1))-0.005,log10(abs(Ws210(4,2)))+0.05,p1)
p1 = '$25\%$';
text(log10(1.0-Ws210(5,1))-0.005,log10(abs(Ws210(5,2)))+0.05,p1)
p1 = '$30\%$';
text(log10(1.0-Ws210(6,1))-0.005,log10(abs(Ws210(6,2)))+0.05,p1)

%
% Fig. 6a and Fig. 6b
%
figure(2)
hold on
% dummy variables for legend
plot(sRMS144(:,1),sRMS144(:,3),'--o','MarkerSize',8.0,'MarkerFaceColor','white' ,'MarkerEdgeColor','k','color','k')
plot(sRMS178(:,1),sRMS178(:,3),'--s','MarkerSize',8.0,'MarkerFaceColor','white','MarkerEdgeColor','k','color','k')
plot(sRMS210(:,1),sRMS210(:,3),'--^','MarkerSize',8.0,'MarkerFaceColor','white','MarkerEdgeColor','k','color','k')
% plot variables
plot(sRMS144(:,1),sRMS144(:,3),'--o','MarkerSize',8.0,'MarkerFaceColor','red' ,'MarkerEdgeColor','k','color','k')
plot(sRMS178(:,1),sRMS178(:,3),'--s','MarkerSize',8.0,'MarkerFaceColor','red','MarkerEdgeColor','k','color','k')
plot(sRMS210(:,1),sRMS210(:,3),'--^','MarkerSize',8.0,'MarkerFaceColor','red','MarkerEdgeColor','k','color','k')
plot(sRMS144(:,1),sqrt((sRMS144(:,2).^2 + sRMS144(:,4).^2)/2.),'--o','MarkerSize',8.0,'MarkerFaceColor','blue' ,'MarkerEdgeColor','k','color','k')
plot(sRMS178(:,1),sqrt((sRMS178(:,2).^2 + sRMS178(:,4).^2)/2.),'--s','MarkerSize',8.0,'MarkerFaceColor','blue','MarkerEdgeColor','k','color','k')
plot(sRMS210(:,1),sqrt((sRMS210(:,2).^2 + sRMS210(:,4).^2)/2.), '--^','MarkerSize',8.0,'MarkerFaceColor','blue','MarkerEdgeColor','k','color','k')
xlabel('$\phi$')
ylabel('$u_{pi,rms}/\sqrt{gD_p}$')
ylim([0 0.4])
legend('$Ga=144$','$Ga=178$','$Ga=210$','Location','NorthEast')

figure(3)
hold on
% dummy variables for legend
plot(fRMS144(:,1),fRMS144(:,3),'--o','MarkerSize',8.0,'MarkerFaceColor','white' ,'MarkerEdgeColor','k','color','k')
plot(fRMS178(:,1),fRMS178(:,3),'--s','MarkerSize',8.0,'MarkerFaceColor','white','MarkerEdgeColor','k','color','k')
plot(fRMS210(:,1),fRMS210(:,3),'--^','MarkerSize',8.0,'MarkerFaceColor','white','MarkerEdgeColor','k','color','k')
% plot variables
plot(fRMS144(:,1),fRMS144(:,3),'--o','MarkerSize',8.0,'MarkerFaceColor','red' ,'MarkerEdgeColor','k','color','k')
plot(fRMS178(:,1),fRMS178(:,3),'--s','MarkerSize',8.0,'MarkerFaceColor','red','MarkerEdgeColor','k','color','k')
plot(fRMS210(:,1),fRMS210(:,3),'--^','MarkerSize',8.0,'MarkerFaceColor','red','MarkerEdgeColor','k','color','k')
plot(fRMS144(:,1),sqrt((fRMS144(:,2).^2 + fRMS144(:,4).^2)/2.),'--o','MarkerSize',8.0,'MarkerFaceColor','blue' ,'MarkerEdgeColor','k','color','k')
plot(fRMS178(:,1),sqrt((fRMS178(:,2).^2 + fRMS178(:,4).^2)/2.),'--s','MarkerSize',8.0,'MarkerFaceColor','blue','MarkerEdgeColor','k','color','k') 
plot(fRMS210(:,1),sqrt((fRMS210(:,2).^2 + fRMS210(:,4).^2)/2.),'--^','MarkerSize',8.0,'MarkerFaceColor','blue','MarkerEdgeColor','k','color','k')
xlabel('$\phi$')
ylabel('$u_{fi,rms}/\sqrt{gD_p}$')
ylim([0 0.4])
legend('$Ga=144$','$Ga=178$','$Ga=210$','Location','SouthEast')

%
% Fig. 7a and Fig. 7b
%
figure(4)
hold on
% dummy variables for legend
plot(log10(sRMS144(:,1)),log10(sRMS144(:,3)./abs(sMean144(:,3))),'o','MarkerSize',8.0,'MarkerFaceColor','white' ,'MarkerEdgeColor','k','color','w')
plot(log10(sRMS178(:,1)),log10(sRMS178(:,3)./abs(sMean178(:,3))),'s','MarkerSize',8.0,'MarkerFaceColor','white','MarkerEdgeColor','k','color','k')
plot(log10(sRMS210(:,1)),log10(sRMS210(:,3)./abs(sMean210(:,3))),'^','MarkerSize',8.0,'MarkerFaceColor','white','MarkerEdgeColor','k','color','k')
% plot variables
plot(log10(sRMS144(:,1)),log10(sRMS144(:,3)./abs(sMean144(:,3))),'o','MarkerSize',8.0,'MarkerFaceColor','red' ,'MarkerEdgeColor','k','color','w')
plot(log10(sRMS178(:,1)),log10(sRMS178(:,3)./abs(sMean178(:,3))),'s','MarkerSize',8.0,'MarkerFaceColor','red','MarkerEdgeColor','k','color','k')
plot(log10(sRMS210(:,1)),log10(sRMS210(:,3)./abs(sMean210(:,3))),'^','MarkerSize',8.0,'MarkerFaceColor','red','MarkerEdgeColor','k','color','k')
plot(log10(sRMS144(:,1)),log10(sqrt((sRMS144(:,2).^2. + sRMS144(:,4).^2.)/2.)./abs(sMean144(:,3))),'o','MarkerSize',8.0,'MarkerFaceColor','blue' ,'MarkerEdgeColor','k','color','k')
plot(log10(sRMS178(:,1)),log10(sqrt((sRMS178(:,2).^2. + sRMS178(:,4).^2.)/2.)./abs(sMean178(:,3))),'s','MarkerSize',8.0,'MarkerFaceColor','blue','MarkerEdgeColor','k','color','k')
plot(log10(sRMS210(:,1)),log10(sqrt((sRMS210(:,2).^2. + sRMS210(:,4).^2.)/2.)./abs(sMean210(:,3))),'^','MarkerSize',8.0,'MarkerFaceColor','blue','MarkerEdgeColor','k','color','k')
xlabel('$log(\phi)$')
ylabel('$log(u_{pi,rms}/|V_s|)$')
x1=xlim;
x2=linspace(x1(1),x1(2),10);
Ga144_v = x2 *0.2907  + -0.1320;
Ga178_v = x2 *0.2572  + -0.2181;
Ga210_v = x2 *0.2085  + -0.2319;
Ga144_h = x2 *0.4294  + -0.1847;
Ga178_h = x2 *0.4205  + -0.2462;
Ga210_h = x2 *0.2845  + -0.3293;
plot(x2,Ga178_v,'--k')
plot(x2,Ga178_h,'--k')
legend('$Ga=144$','$Ga=178$','$Ga=210$','Location','SouthEast')

figure(5)
hold on
% dummy variables for legend
plot(log10(fRMS144(:,1)),log10(fRMS144(:,3)./sRMS144(:,3)),'o','MarkerSize',8.0,'MarkerFaceColor','white' ,'MarkerEdgeColor','k','color','w')
plot(log10(fRMS178(:,1)),log10(fRMS178(:,3)./sRMS178(:,3)),'s','MarkerSize',8.0,'MarkerFaceColor','white','MarkerEdgeColor','k','color','w')
plot(log10(fRMS210(:,1)),log10(fRMS210(:,3)./sRMS210(:,3)),'^','MarkerSize',8.0,'MarkerFaceColor','white','MarkerEdgeColor','k','color','k')
% plot variables
plot(log10(fRMS144(:,1)),log10(fRMS144(:,3)./sRMS144(:,3)),'o','MarkerSize',8.0,'MarkerFaceColor','red' ,'MarkerEdgeColor','k','color','w')
plot(log10(fRMS178(:,1)),log10(fRMS178(:,3)./sRMS178(:,3)),'s','MarkerSize',8.0,'MarkerFaceColor','red','MarkerEdgeColor','k','color','k')
plot(log10(fRMS210(:,1)),log10(fRMS210(:,3)./sRMS210(:,3)),'^','MarkerSize',8.0,'MarkerFaceColor','red','MarkerEdgeColor','k','color','k')
plot(log10(fRMS144(:,1)),log10(sqrt((fRMS144(:,2).^2. + fRMS144(:,4).^2.)/2.)./sqrt((sRMS144(:,2).^2+sRMS144(:,4).^2)/2.)),'o','MarkerSize',8.0,'MarkerFaceColor','blue' ,'MarkerEdgeColor','k','color','k')
plot(log10(fRMS178(:,1)),log10(sqrt((fRMS178(:,2).^2. + fRMS178(:,4).^2.)/2.)./sqrt((sRMS178(:,2).^2+sRMS178(:,4).^2)/2.)),'s','MarkerSize',8.0,'MarkerFaceColor','blue','MarkerEdgeColor','k','color','k')
plot(log10(fRMS210(:,1)),log10(sqrt((fRMS210(:,2).^2. + fRMS210(:,4).^2.)/2.)./sqrt((sRMS210(:,2).^2+sRMS210(:,4).^2)/2.)),'^','MarkerSize',8.0,'MarkerFaceColor','blue','MarkerEdgeColor','k','color','k')
plot([-2.5 -0.5],[0 0],'-k')
x1=xlim;
x2=linspace(x1(1),x1(2),10);
Ga144_vf = x2 * 0.0882 + 0.2947;
Ga178_vf = x2 * 0.1128 + 0.3490;
Ga210_vf = x2 * 0.1360 + 0.3543;
Ga144_hf = x2 * 0.1094 + 0.1586;
Ga178_hf = x2 * 0.1629 + 0.2454;
Ga210_hf = x2 * 0.2274 + 0.2937;
plot(x2,Ga178_vf,'--k')
plot(x2,Ga178_hf,'--k')
xlabel('$log(\phi)$')
ylabel('$log(u_{fi,rms}/u_{pi,rms})$')
legend('$Ga=144$','$Ga=178$','$Ga=210$','Location','SouthEast')

PDFx = linspace(-5,5,20);
PDFy = (1/sqrt(2.*pi))*exp(-0.5*PDFx.^2);

%
% Fig. 8a and Fig. 8b
%
figure(6)
hold on
plot(Fig8a_Ga210_pdf_CaseJ(:,1),Fig8a_Ga210_pdf_CaseJ(:,2))
plot(Fig8a_Ga210_pdf_CaseA(:,1),Fig8a_Ga210_pdf_CaseA(:,2))
plot(Fig8a_Ga210_pdf_CaseH(:,1),Fig8a_Ga210_pdf_CaseH(:,2))
plot(Fig8a_Ga210_pdf_CaseB(:,1),Fig8a_Ga210_pdf_CaseB(:,2))
plot(Fig8a_Ga210_pdf_CaseI(:,1),Fig8a_Ga210_pdf_CaseI(:,2))
plot(Fig8a_Ga210_pdf_CaseC(:,1),Fig8a_Ga210_pdf_CaseC(:,2),'--')
plot(Fig8a_Ga210_pdf_CaseG(:,1),Fig8a_Ga210_pdf_CaseG(:,2),'--')
plot(Fig8a_Ga210_pdf_CaseD(:,1),Fig8a_Ga210_pdf_CaseD(:,2),'--')
plot(Fig8a_Ga210_pdf_CaseE(:,1),Fig8a_Ga210_pdf_CaseE(:,2),'--')
plot(Fig8a_Ga210_pdf_CaseF(:,1),Fig8a_Ga210_pdf_CaseF(:,2),'--')
plot([0 0],[0 0.5],'--','LineWidth',0.8,'color','black')
plot(PDFx,PDFy,'sk','LineWidth',1.4)
xlim([-5 5])
ylim([0 0.6])
xlabel('$(v_p-V_s)/v_{p,rms}$')
ylabel('$(p.d.f,)v_{p,rms}$')
legend('$\phi=0.02$','$\phi=0.04$','$\phi=0.06$','$\phi=0.08$','$\phi=0.10$','$\phi=0.15$','$\phi=0.20$','$\phi=0.25$','$\phi=0.30$')

figure(7)
hold on
plot(Fig8b_Ga210_pdf_CaseJ(:,1),Fig8b_Ga210_pdf_CaseJ(:,2))
plot(Fig8b_Ga210_pdf_CaseA(:,1),Fig8b_Ga210_pdf_CaseA(:,2))
plot(Fig8b_Ga210_pdf_CaseH(:,1),Fig8b_Ga210_pdf_CaseH(:,2))
plot(Fig8b_Ga210_pdf_CaseB(:,1),Fig8b_Ga210_pdf_CaseB(:,2))
plot(Fig8b_Ga210_pdf_CaseI(:,1),Fig8b_Ga210_pdf_CaseI(:,2))
plot(Fig8b_Ga210_pdf_CaseC(:,1),Fig8b_Ga210_pdf_CaseC(:,2),'--')
plot(Fig8b_Ga210_pdf_CaseG(:,1),Fig8b_Ga210_pdf_CaseG(:,2),'--')
plot(Fig8b_Ga210_pdf_CaseD(:,1),Fig8b_Ga210_pdf_CaseD(:,2),'--')
plot(Fig8b_Ga210_pdf_CaseE(:,1),Fig8b_Ga210_pdf_CaseE(:,2),'--')
plot(Fig8b_Ga210_pdf_CaseF(:,1),Fig8b_Ga210_pdf_CaseF(:,2),'--')
plot([0 0],[0 0.5],'--','LineWidth',0.8,'color','black')
plot(PDFx,PDFy,'sk','LineWidth',1.4)
xlim([-5 5])
ylim([0 0.6])
xlabel('$u_p/u_{p,rms}$')
ylabel('$(p.d.f,)u_{p,rms}$')
legend('$\phi=0.02$','$\phi=0.04$','$\phi=0.06$','$\phi=0.08$','$\phi=0.10$','$\phi=0.15$','$\phi=0.20$','$\phi=0.25$','$\phi=0.30$')


%
% Fig. 8c and Fig. 8d
%
figure(8)
hold on
plot(Fig8c_Ga210_pdf_CaseA(:,1),Fig8c_Ga210_pdf_CaseA(:,2))
plot(Fig8c_Ga210_pdf_CaseH(:,1),Fig8c_Ga210_pdf_CaseH(:,2))
plot(Fig8c_Ga210_pdf_CaseB(:,1),Fig8c_Ga210_pdf_CaseB(:,2))
plot(Fig8c_Ga210_pdf_CaseI(:,1),Fig8c_Ga210_pdf_CaseI(:,2))
plot(Fig8c_Ga210_pdf_CaseC(:,1),Fig8c_Ga210_pdf_CaseC(:,2),'--')
plot(Fig8c_Ga210_pdf_CaseG(:,1),Fig8c_Ga210_pdf_CaseG(:,2),'--')
plot(Fig8c_Ga210_pdf_CaseD(:,1),Fig8c_Ga210_pdf_CaseD(:,2),'--')
plot(Fig8c_Ga210_pdf_CaseE(:,1),Fig8c_Ga210_pdf_CaseE(:,2),'--')
plot(Fig8c_Ga210_pdf_CaseF(:,1),Fig8c_Ga210_pdf_CaseF(:,2),'--')
plot([0 0],[0 0.5],'--','LineWidth',0.8,'color','black')
plot(PDFx,PDFy,'sk','LineWidth',1.4)
xlim([-5 5])
ylim([0 0.6])
xlabel('$(v_p-V_s)/v_{p,rms}$')
ylabel('$(p.d.f,)v_{p,rms}$')
legend('$\phi=0.02$','$\phi=0.04$','$\phi=0.06$','$\phi=0.08$','$\phi=0.10$','$\phi=0.15$','$\phi=0.20$','$\phi=0.25$','$\phi=0.30$')

figure(9)
hold on
plot(Fig8d_Ga210_pdf_CaseA(:,1),Fig8d_Ga210_pdf_CaseA(:,2))
plot(Fig8d_Ga210_pdf_CaseH(:,1),Fig8d_Ga210_pdf_CaseH(:,2))
plot(Fig8d_Ga210_pdf_CaseB(:,1),Fig8d_Ga210_pdf_CaseB(:,2))
plot(Fig8d_Ga210_pdf_CaseI(:,1),Fig8d_Ga210_pdf_CaseI(:,2))
plot(Fig8d_Ga210_pdf_CaseC(:,1),Fig8d_Ga210_pdf_CaseC(:,2),'--')
plot(Fig8d_Ga210_pdf_CaseG(:,1),Fig8d_Ga210_pdf_CaseG(:,2),'--')
plot(Fig8d_Ga210_pdf_CaseD(:,1),Fig8d_Ga210_pdf_CaseD(:,2),'--')
plot(Fig8d_Ga210_pdf_CaseE(:,1),Fig8d_Ga210_pdf_CaseE(:,2),'--')
plot(Fig8d_Ga210_pdf_CaseF(:,1),Fig8d_Ga210_pdf_CaseF(:,2),'--')
plot([0 0],[0 0.5],'--','LineWidth',0.8,'color','black')
plot(PDFx,PDFy,'sk','LineWidth',1.4)
xlim([-5 5])
ylim([0 0.6])
xlabel('$u_p/u_{p,rms}$')
ylabel('$(p.d.f,)u_{p,rms}$')
legend('$\phi=0.02$','$\phi=0.04$','$\phi=0.06$','$\phi=0.08$','$\phi=0.10$','$\phi=0.15$','$\phi=0.20$','$\phi=0.25$','$\phi=0.30$')


%
% Fig. 8e and Fig. 8f
%
figure(10)
hold on
plot(Fig8e_Ga210_pdf_CaseA(:,1),Fig8e_Ga210_pdf_CaseA(:,2))
plot(Fig8e_Ga210_pdf_CaseB(:,1),Fig8e_Ga210_pdf_CaseB(:,2))
plot(Fig8e_Ga210_pdf_CaseC(:,1),Fig8e_Ga210_pdf_CaseC(:,2),'--')
plot(Fig8e_Ga210_pdf_CaseD(:,1),Fig8e_Ga210_pdf_CaseD(:,2),'--')
plot(Fig8e_Ga210_pdf_CaseE(:,1),Fig8e_Ga210_pdf_CaseE(:,2),'--')
plot(Fig8e_Ga210_pdf_CaseF(:,1),Fig8e_Ga210_pdf_CaseF(:,2),'--')
plot([0 0],[0 0.5],'--','LineWidth',0.8,'color','black')
plot(PDFx,PDFy,'sk','LineWidth',1.4)
xlim([-5 5])
ylim([0 0.6])
xlabel('$(v_p-V_s)/v_{p,rms}$')
ylabel('$(p.d.f,)v_{p,rms}$')
legend('$\phi=0.02$','$\phi=0.06$','$\phi=0.10$','$\phi=0.20$','$\phi=0.25$','$\phi=0.30$')

figure(11)
hold on
plot(Fig8f_Ga210_pdf_CaseA(:,1),Fig8f_Ga210_pdf_CaseA(:,2))
plot(Fig8f_Ga210_pdf_CaseB(:,1),Fig8f_Ga210_pdf_CaseB(:,2))
plot(Fig8f_Ga210_pdf_CaseC(:,1),Fig8f_Ga210_pdf_CaseC(:,2),'--')
plot(Fig8f_Ga210_pdf_CaseD(:,1),Fig8f_Ga210_pdf_CaseD(:,2),'--')
plot(Fig8f_Ga210_pdf_CaseE(:,1),Fig8f_Ga210_pdf_CaseE(:,2),'--')
plot(Fig8f_Ga210_pdf_CaseF(:,1),Fig8f_Ga210_pdf_CaseF(:,2),'--')
plot([0 0],[0 0.5],'--','LineWidth',0.8,'color','black')
plot(PDFx,PDFy,'sk','LineWidth',1.4)
xlim([-5 5])
ylim([0 0.6])
xlabel('$u_p/u_{p,rms}$')
ylabel('$(p.d.f,)u_{p,rms}$')
legend('$\phi=0.02$','$\phi=0.06$','$\phi=0.10$','$\phi=0.20$','$\phi=0.25$','$\phi=0.30$')

%
% Fig. 9a - 9f
%
figure(12)
hold on
plot(Fig9_Ga144_CaseJ(:,1),Fig9_Ga144_CaseJ(:,3),'LineWidth',1.2)
plot(Fig9_Ga144_CaseA(:,1),Fig9_Ga144_CaseA(:,3),'LineWidth',1.2)
plot(Fig9_Ga144_CaseH(:,1),Fig9_Ga144_CaseH(:,3),'LineWidth',1.2)
plot(Fig9_Ga144_CaseB(:,1),Fig9_Ga144_CaseB(:,3),'LineWidth',1.2)
plot(Fig9_Ga144_CaseI(:,1),Fig9_Ga144_CaseI(:,3),'LineWidth',1.2)
plot(Fig9_Ga144_CaseC(:,1),Fig9_Ga144_CaseC(:,3),'--','LineWidth',1.2)
plot(Fig9_Ga144_CaseG(:,1),Fig9_Ga144_CaseG(:,3),'--','LineWidth',1.2)
plot(Fig9_Ga144_CaseD(:,1),Fig9_Ga144_CaseD(:,3),'--','LineWidth',1.2)
plot(Fig9_Ga144_CaseE(:,1),Fig9_Ga144_CaseE(:,3),'--','LineWidth',1.2)
plot(Fig9_Ga144_CaseF(:,1),Fig9_Ga144_CaseF(:,3),'--','LineWidth',1.2)
legend('$\phi=0.5\%$',...
       '$\phi=2\%$',...
       '$\phi=4\%$',...
       '$\phi=6\%$',...
       '$\phi=8\%$',...
       '$\phi=10\%$',...
       '$\phi=15\%$',...
       '$\phi=20\%$',...
       '$\phi=25\%$',...
       '$\phi=30\%$',...
       'Location','NorthEast')
xlim([0 400.])
xlabel('$t/\sqrt{D_p/g}$')
ylabel('$\rho_{vv}$','FontSize',26)

figure(13)
hold on
plot(Fig9_Ga144_CaseJ(:,1),0.5*(Fig9_Ga144_CaseJ(:,2)+Fig9_Ga144_CaseJ(:,4)),'LineWidth',1.2)
plot(Fig9_Ga144_CaseA(:,1),0.5*(Fig9_Ga144_CaseA(:,2)+Fig9_Ga144_CaseA(:,4)),'LineWidth',1.2)
plot(Fig9_Ga144_CaseH(:,1),0.5*(Fig9_Ga144_CaseH(:,2)+Fig9_Ga144_CaseH(:,4)),'LineWidth',1.2)
plot(Fig9_Ga144_CaseB(:,1),0.5*(Fig9_Ga144_CaseB(:,2)+Fig9_Ga144_CaseB(:,4)),'LineWidth',1.2)
plot(Fig9_Ga144_CaseI(:,1),0.5*(Fig9_Ga144_CaseI(:,2)+Fig9_Ga144_CaseI(:,4)),'LineWidth',1.2)
plot(Fig9_Ga144_CaseC(:,1),0.5*(Fig9_Ga144_CaseC(:,2)+Fig9_Ga144_CaseC(:,4)),'--','LineWidth',1.2)
plot(Fig9_Ga144_CaseG(:,1),0.5*(Fig9_Ga144_CaseG(:,2)+Fig9_Ga144_CaseG(:,4)),'--','LineWidth',1.2)
plot(Fig9_Ga144_CaseD(:,1),0.5*(Fig9_Ga144_CaseD(:,2)+Fig9_Ga144_CaseD(:,4)),'--','LineWidth',1.2)
plot(Fig9_Ga144_CaseE(:,1),0.5*(Fig9_Ga144_CaseE(:,2)+Fig9_Ga144_CaseE(:,4)),'--','LineWidth',1.2)
plot(Fig9_Ga144_CaseF(:,1),0.5*(Fig9_Ga144_CaseF(:,2)+Fig9_Ga144_CaseF(:,4)),'--','LineWidth',1.2)
legend('$\phi=0.5\%$',...
       '$\phi=2\%$',...
       '$\phi=4\%$',...
       '$\phi=6\%$',...
       '$\phi=8\%$',...
       '$\phi=10\%$',...
       '$\phi=15\%$',...
       '$\phi=20\%$',...
       '$\phi=25\%$',...
       '$\phi=30\%$',...
       'Location','NorthEast')
xlim([0 400.])
xlabel('$t/\sqrt{D_p/g}$')
ylabel('$\rho_{uu}$','FontSize',26)

figure(14)
hold on
plot(Fig9_Ga178_CaseA(:,1),Fig9_Ga178_CaseA(:,3),'LineWidth',1.2)
plot(Fig9_Ga178_CaseH(:,1),Fig9_Ga178_CaseH(:,3),'LineWidth',1.2)
plot(Fig9_Ga178_CaseB(:,1),Fig9_Ga178_CaseB(:,3),'LineWidth',1.2)
plot(Fig9_Ga178_CaseI(:,1),Fig9_Ga178_CaseI(:,3),'LineWidth',1.2)
plot(Fig9_Ga178_CaseC(:,1),Fig9_Ga178_CaseC(:,3),'--','LineWidth',1.2)
plot(Fig9_Ga178_CaseG(:,1),Fig9_Ga178_CaseG(:,3),'--','LineWidth',1.2)
plot(Fig9_Ga178_CaseD(:,1),Fig9_Ga178_CaseD(:,3),'--','LineWidth',1.2)
plot(Fig9_Ga178_CaseE(:,1),Fig9_Ga178_CaseE(:,3),'--','LineWidth',1.2)
plot(Fig9_Ga178_CaseF(:,1),Fig9_Ga178_CaseF(:,3),'--','LineWidth',1.2)
legend('$\phi=2\%$',...
       '$\phi=4\%$',...
       '$\phi=6\%$',...
       '$\phi=8\%$',...
       '$\phi=10\%$',...
       '$\phi=15\%$',...
       '$\phi=20\%$',...
       '$\phi=25\%$',...
       '$\phi=30\%$',...
       'Location','NorthEast')
xlim([0 400.])
xlabel('$t/\sqrt{D_p/g}$')
ylabel('$\rho_{vv}$','FontSize',26)

figure(15)
hold on
plot(Fig9_Ga178_CaseA(:,1),0.5*(Fig9_Ga178_CaseA(:,2)+Fig9_Ga178_CaseA(:,4)),'LineWidth',1.2)
plot(Fig9_Ga178_CaseH(:,1),0.5*(Fig9_Ga178_CaseH(:,2)+Fig9_Ga178_CaseH(:,4)),'LineWidth',1.2)
plot(Fig9_Ga178_CaseB(:,1),0.5*(Fig9_Ga178_CaseB(:,2)+Fig9_Ga178_CaseB(:,4)),'LineWidth',1.2)
plot(Fig9_Ga178_CaseI(:,1),0.5*(Fig9_Ga178_CaseI(:,2)+Fig9_Ga178_CaseI(:,4)),'LineWidth',1.2)
plot(Fig9_Ga178_CaseC(:,1),0.5*(Fig9_Ga178_CaseC(:,2)+Fig9_Ga178_CaseC(:,4)),'--','LineWidth',1.2)
plot(Fig9_Ga178_CaseG(:,1),0.5*(Fig9_Ga178_CaseG(:,2)+Fig9_Ga178_CaseG(:,4)),'--','LineWidth',1.2)
plot(Fig9_Ga178_CaseD(:,1),0.5*(Fig9_Ga178_CaseD(:,2)+Fig9_Ga178_CaseD(:,4)),'--','LineWidth',1.2)
plot(Fig9_Ga178_CaseE(:,1),0.5*(Fig9_Ga178_CaseE(:,2)+Fig9_Ga178_CaseE(:,4)),'--','LineWidth',1.2)
plot(Fig9_Ga178_CaseF(:,1),0.5*(Fig9_Ga178_CaseF(:,2)+Fig9_Ga178_CaseF(:,4)),'--','LineWidth',1.2)
legend('$\phi=2\%$',...
       '$\phi=4\%$',...
       '$\phi=6\%$',...
       '$\phi=8\%$',...
       '$\phi=10\%$',...
       '$\phi=15\%$',...
       '$\phi=20\%$',...
       '$\phi=25\%$',...
       '$\phi=30\%$',...
       'Location','NorthEast')
xlim([0 400.])
xlabel('$t/\sqrt{D_p/g}$')
ylabel('$\rho_{uu}$','FontSize',26)

figure(16)
hold on
plot(Fig9_Ga210_CaseA(:,1),Fig9_Ga210_CaseA(:,3),'LineWidth',1.2)
plot(Fig9_Ga210_CaseB(:,1),Fig9_Ga210_CaseB(:,3),'LineWidth',1.2)
plot(Fig9_Ga210_CaseC(:,1),Fig9_Ga210_CaseC(:,3),'--','LineWidth',1.2)
plot(Fig9_Ga210_CaseD(:,1),Fig9_Ga210_CaseD(:,3),'--','LineWidth',1.2)
plot(Fig9_Ga210_CaseE(:,1),Fig9_Ga210_CaseE(:,3),'--','LineWidth',1.2)
plot(Fig9_Ga210_CaseF(:,1),Fig9_Ga210_CaseF(:,3),'--','LineWidth',1.2)
legend('$\phi=2\%$',...
       '$\phi=6\%$',...
       '$\phi=10\%$',...
       '$\phi=20\%$',...
       '$\phi=25\%$',...
       '$\phi=30\%$',...
       'Location','NorthEast')
xlim([0 400.])
xlabel('$t/\sqrt{D_p/g}$')
ylabel('$\rho_{vv}$','FontSize',26)

figure(17)
hold on
plot(Fig9_Ga210_CaseA(:,1),0.5*(Fig9_Ga210_CaseA(:,2)+Fig9_Ga210_CaseA(:,4)),'LineWidth',1.2)
plot(Fig9_Ga210_CaseB(:,1),0.5*(Fig9_Ga210_CaseB(:,2)+Fig9_Ga210_CaseB(:,4)),'LineWidth',1.2)
plot(Fig9_Ga210_CaseC(:,1),0.5*(Fig9_Ga210_CaseC(:,2)+Fig9_Ga210_CaseC(:,4)),'--','LineWidth',1.2)
plot(Fig9_Ga210_CaseD(:,1),0.5*(Fig9_Ga210_CaseD(:,2)+Fig9_Ga210_CaseD(:,4)),'--','LineWidth',1.2)
plot(Fig9_Ga210_CaseE(:,1),0.5*(Fig9_Ga210_CaseE(:,2)+Fig9_Ga210_CaseE(:,4)),'--','LineWidth',1.2)
plot(Fig9_Ga210_CaseF(:,1),0.5*(Fig9_Ga210_CaseF(:,2)+Fig9_Ga210_CaseF(:,4)),'--','LineWidth',1.2)
legend('$\phi=2\%$',...
       '$\phi=6\%$',...
       '$\phi=10\%$',...
       '$\phi=20\%$',...
       '$\phi=25\%$',...
       '$\phi=30\%$',...
       'Location','NorthEast')
xlim([0 400.])
xlabel('$t/\sqrt{D_p/g}$')
ylabel('$\rho_{uu}$','FontSize',26)

%
% Fig. 10
%
figure(18)
hold on
% dummy variables for legend
plot(Fig10_tau_Ga144(:,1),Fig10_tau_Ga144(:,3),'-o','MarkerSize',6,'MarkerFaceColor','white'  ,'MarkerEdgeColor','black','color','k')
plot(Fig10_tau_Ga178(:,1),Fig10_tau_Ga178(:,3),'-s','MarkerSize',6,'MarkerFaceColor','white' ,'MarkerEdgeColor','black','color','k')
plot(Fig10_tau_Ga210(:,1),Fig10_tau_Ga210(:,3),'-^','MarkerSize',6,'MarkerFaceColor','white','MarkerEdgeColor','black','color','k')
% plot variables          t variable
plot(Fig10_tau_Ga144(:,1),0.5*(Fig10_tau_Ga144(:,2)+Fig10_tau_Ga144(:,4)),'-o','MarkerSize',6,'MarkerFaceColor','blue'  ,'MarkerEdgeColor','black','color','k')
plot(Fig10_tau_Ga178(:,1),0.5*(Fig10_tau_Ga178(:,2)+Fig10_tau_Ga178(:,4)),'-s','MarkerSize',6,'MarkerFaceColor','blue' ,'MarkerEdgeColor','black','color','k')
plot(Fig10_tau_Ga210(:,1),0.5*(Fig10_tau_Ga210(:,2)+Fig10_tau_Ga210(:,4)),'-^','MarkerSize',6,'MarkerFaceColor','blue','MarkerEdgeColor','black','color','k')
plot(Fig10_tau_Ga144(:,1),Fig10_tau_Ga144(:,3),'-o','MarkerSize',6,'MarkerFaceColor','red'  ,'MarkerEdgeColor','black','color','k')
plot(Fig10_tau_Ga178(:,1),Fig10_tau_Ga178(:,3),'-s','MarkerSize',6,'MarkerFaceColor','red' ,'MarkerEdgeColor','black','color','k')
plot(Fig10_tau_Ga210(:,1),Fig10_tau_Ga210(:,3),'-^','MarkerSize',6,'MarkerFaceColor','red','MarkerEdgeColor','black','color','k')
ylabel('$\tau_L/\sqrt{D_p/g}$')
xlabel('${\phi}$')
legend('$Ga=144$','$Ga=178$','$Ga=210$')

%
% Fig. 11 a-d
%
figure(19)
hold on
plot(Fig11_Ga144_CaseJ(:,1),Fig11_Ga144_CaseJ(:,3),'LineWidth',1.3)
plot(Fig11_Ga144_CaseA(:,1),Fig11_Ga144_CaseA(:,3),'LineWidth',1.3)
plot(Fig11_Ga144_CaseB(:,1),Fig11_Ga144_CaseB(:,3),'LineWidth',1.3)
plot(Fig11_Ga144_CaseC(:,1),Fig11_Ga144_CaseC(:,3),'--','LineWidth',1.3)
plot(Fig11_Ga144_CaseD(:,1),Fig11_Ga144_CaseD(:,3),'--','LineWidth',1.3)
plot(Fig11_Ga144_CaseE(:,1),Fig11_Ga144_CaseE(:,3),'--','LineWidth',1.3)
plot(Fig11_Ga144_CaseF(:,1),Fig11_Ga144_CaseF(:,3),'--','LineWidth',1.3)
legend('$\phi=0.5\%$',...
       '$\phi=2\%$',...
       '$\phi=6\%$',...
       '$\phi=10\%$',...
       '$\phi=20\%$',...
       '$\phi=25\%$',...
       '$\phi=30\%$',...
       'Location','NorthWest')
xlim([-200 200])
xlabel('$\tau/\sqrt{D_p/g}$')
ylabel('$\rho_{vu}$','FontSize',25)

figure(20)
hold on
plot(Fig11_Ga178_CaseA(:,1),Fig11_Ga178_CaseA(:,3),'LineWidth',1.3)
plot(Fig11_Ga178_CaseB(:,1),Fig11_Ga178_CaseB(:,3),'LineWidth',1.3)
plot(Fig11_Ga178_CaseC(:,1),Fig11_Ga178_CaseC(:,3),'--','LineWidth',1.3)
plot(Fig11_Ga178_CaseG(:,1),Fig11_Ga178_CaseG(:,3),'--','LineWidth',1.3)
plot(Fig11_Ga178_CaseE(:,1),Fig11_Ga178_CaseE(:,3),'--','LineWidth',1.3)
plot(Fig11_Ga178_CaseF(:,1),Fig11_Ga178_CaseF(:,3),'--','LineWidth',1.3)
legend('$\pGahi=2\%$',...         Ga
       '$\phi=6\%$',...
       '$\phi=10\%$',...
       '$\phi=15\%$',...
       '$\phi=25\%$',...
       '$\phi=30\%$',...
       'Location','NorthWest')
xlim([-200 200])
xlabel('$\tau/\sqrt{D_p/g}$')
ylabel('$\rho_{vu}$','FontSize',25)

figure(21)
hold on
plot(Fig11_Ga210_CaseA(:,1),Fig11_Ga210_CaseA(:,3),'LineWidth',1.3)
plot(Fig11_Ga210_CaseB(:,1),Fig11_Ga210_CaseB(:,3),'LineWidth',1.3)
plot(Fig11_Ga210_CaseC(:,1),Fig11_Ga210_CaseC(:,3),'--','LineWidth',1.3)
plot(Fig11_Ga210_CaseD(:,1),Fig11_Ga210_CaseD(:,3),'--','LineWidth',1.3)
plot(Fig11_Ga210_CaseE(:,1),Fig11_Ga210_CaseE(:,3),'--','LineWidth',1.3)
plot(Fig11_Ga210_CaseF(:,1),Fig11_Ga210_CaseF(:,3),'--','LineWidth',1.3)
legend('$\pGahi=2\%$',...         Ga
       '$\phi=6\%$',...
       '$\phi=10\%$',...
       '$\phi=20\%$',...
       '$\phi=25\%$',...
       '$\phi=30\%$',...
       'Location','NorthWest')
xlim([-200 200])
xlabel('$\tau/\sqrt{D_p/g}$')
ylabel('$\rho_{vu}$','FontSize',25)

figure(22)
hold on
plot(Ga144_CCoeff(:,1),Ga144_CCoeff(:,2),'-s','Linewidth',2.0)
plot(Ga178_CCoeff(:,1),Ga178_CCoeff(:,2),'-s','Linewidth',2.0)
plot(Ga210_CCoeff(:,1),Ga210_CCoeff(:,2),'-s','Linewidth',2.0)
xlabel('$\phi$')
ylabel('$r_{vu}$')
legend('Ga 144','Ga 178','Ga 210')

%
% Fig. 12 a - f
%
figure(23)
x1 = linspace(10^-2.5,10^0,50);
y1 = 0.8./(x1.^0.6);
y2 = 0.15./(x1.^3);
loglog(Fig12_Ga144_CaseJ(:,16),Fig12_Ga144_CaseJ(:,18), ...
       Fig12_Ga144_CaseA(:,16),Fig12_Ga144_CaseA(:,18), ...
       Fig12_Ga144_CaseH(:,16),Fig12_Ga144_CaseH(:,18), ...
       Fig12_Ga144_CaseB(:,16),Fig12_Ga144_CaseB(:,18), ...
       Fig12_Ga144_CaseI(:,16),Fig12_Ga144_CaseI(:,18), ...
       Fig12_Ga144_CaseC(:,16),Fig12_Ga144_CaseC(:,18),'--', ...
       Fig12_Ga144_CaseG(:,16),Fig12_Ga144_CaseG(:,18),'--', ...
       Fig12_Ga144_CaseD(:,16),Fig12_Ga144_CaseD(:,18),'--', ...
       Fig12_Ga144_CaseE(:,16),Fig12_Ga144_CaseE(:,18),'--', ...
       Fig12_Ga144_CaseF(:,16),Fig12_Ga144_CaseF(:,18),'--',...
       x1,y1,'--k', ...
       x1,y2,'--k', 'LineWidth',1.5)
lgd = legend('$\phi=0.5\%$',...
       '$\phi=2\%$',...
       '$\phi=4\%$',...
       '$\phi=6\%$',...
       '$\phi=8\%$',...
       '$\phi=10\%$',...
       '$\phi=15\%$',...
       '$\phi=20\%$',...
       '$\phi=25\%$',...
       '$\phi=30\%$',...
       'Location','SouthWest')
set(lgd,'FontSize',10);
xlim([10^-2.5 10^0])
ylim([10^-2 100])
xlabel('$\omega \sqrt{D_p/g}$')
ylabel('$E/[R_0\sqrt{D_p/g}]$')
text(0.6042,1.582,'$\frac{0.8}{\omega_*^{0.6}}$','FontSize',20)
text(0.3383,5.018,'$\frac{0.15}{\omega_*^3}$','FontSize',20)


figure(24)
x1 = linspace(10^-2.5,10^0,50);
y1 = 0.2./(x1.^1.25);
y2 = 0.05./(x1.^2.75);
loglog(Fig12_Ga144_CaseJ(:,6),Fig12_Ga144_CaseJ(:,8), ...
       Fig12_Ga144_CaseA(:,6),Fig12_Ga144_CaseA(:,8), ...
       Fig12_Ga144_CaseH(:,6),Fig12_Ga144_CaseH(:,8), ...
       Fig12_Ga144_CaseB(:,6),Fig12_Ga144_CaseB(:,8), ...
       Fig12_Ga144_CaseI(:,6),Fig12_Ga144_CaseI(:,8), ...
       Fig12_Ga144_CaseC(:,6),Fig12_Ga144_CaseC(:,8),'--', ...
       Fig12_Ga144_CaseG(:,6),Fig12_Ga144_CaseG(:,8),'--', ...
       Fig12_Ga144_CaseD(:,6),Fig12_Ga144_CaseD(:,8),'--', ...
       Fig12_Ga144_CaseE(:,6),Fig12_Ga144_CaseE(:,8),'--', ...
       Fig12_Ga144_CaseF(:,6),Fig12_Ga144_CaseF(:,8),'--', ...
       x1,y1,'--k', ...
       x1,y2,'--k', 'LineWidth',1.5)
lgd = legend('$\phi=0.5\%$',...
       '$\phi=2\%$',...
       '$\phi=4\%$',...
       '$\phi=6\%$',...
       '$\phi=8\%$',...
       '$\phi=10\%$',...
       '$\phi=15\%$',...
       '$\phi=20\%$',...
       '$\phi=25\%$',...
       '$\phi=30\%$',...
       'Location','SouthWest')
set(lgd,'FontSize',10);
xlim([10^-2.5 10^0])
ylim([10^-2 100])
xlabel('$\omega \sqrt{D_p/g}$')
ylabel('$E/[R_0\sqrt{D_p/g}]$')
text(0.5728,0.6014,'$\frac{0.2}{\omega_*^{1.25}}$','FontSize',20)
text(0.1656,10.01,'$\frac{0.05}{\omega_*^{2.75}}$','FontSize',20)

figure(25)
x1 = linspace(10^-2.5,10^0,50);
y1 = 0.8./(x1.^0.6);
y2 = 0.15./(x1.^3);
loglog(Fig12_Ga178_CaseA(:,16),Fig12_Ga178_CaseA(:,18), ...
       Fig12_Ga178_CaseH(:,16),Fig12_Ga178_CaseH(:,18), ...
       Fig12_Ga178_CaseB(:,16),Fig12_Ga178_CaseB(:,18), ...
       Fig12_Ga178_CaseI(:,16),Fig12_Ga178_CaseI(:,18), ...
       Fig12_Ga178_CaseC(:,16),Fig12_Ga178_CaseC(:,18),'--', ...
       Fig12_Ga178_CaseG(:,16),Fig12_Ga178_CaseG(:,18),'--', ...
       Fig12_Ga178_CaseD(:,16),Fig12_Ga178_CaseD(:,18),'--', ...
       Fig12_Ga178_CaseE(:,16),Fig12_Ga178_CaseE(:,18),'--', ...
       Fig12_Ga178_CaseF(:,16),Fig12_Ga178_CaseF(:,18),'--', ...
       x1,y1,'--k', ...
       x1,y2,'--k', 'LineWidth',1.5)
lgd = legend('$\phi=2\%$',...
       '$\phi=4\%$',...
       '$\phi=6\%$',...
       '$\phi=8\%$',...
       '$\phi=10\%$',...
       '$\phi=15\%$',...
       '$\phi=20\%$',...
       '$\phi=25\%$',...
       '$\phi=30\%$',...
       'Location','SouthWest')
set(lgd,'FontSize',10);
xlim([10^-2.5 10^0])
ylim([10^-2 100])
xlabel('$\omega \sqrt{D_p/g}$')
ylabel('$E/[R_0\sqrt{D_p/g}]$')
text(0.6042,1.582,'$\frac{0.8}{\omega_*^{0.6}}$','FontSize',20)
text(0.3383,5.018,'$\frac{0.15}{\omega_*^3}$','FontSize',20)

figure(26)
x1 = linspace(10^-2.5,10^0,50);
y1 = 0.2./(x1.^1.25);
y2 = 0.05./(x1.^2.75);
loglog(Fig12_Ga178_CaseA(:,6),Fig12_Ga178_CaseA(:,8), ...
       Fig12_Ga178_CaseH(:,6),Fig12_Ga178_CaseH(:,8), ...
       Fig12_Ga178_CaseB(:,6),Fig12_Ga178_CaseB(:,8), ...
       Fig12_Ga178_CaseI(:,6),Fig12_Ga178_CaseI(:,8), ...
       Fig12_Ga178_CaseC(:,6),Fig12_Ga178_CaseC(:,8),'--', ...
       Fig12_Ga178_CaseG(:,6),Fig12_Ga178_CaseG(:,8),'--', ...
       Fig12_Ga178_CaseD(:,6),Fig12_Ga178_CaseD(:,8),'--', ...
       Fig12_Ga178_CaseE(:,6),Fig12_Ga178_CaseE(:,8),'--', ...
       Fig12_Ga178_CaseF(:,6),Fig12_Ga178_CaseF(:,8),'--', ...
       x1,y1,'--k', ...
       x1,y2,'--k', 'LineWidth',1.5)
lgd = legend('$\phi=2\%$',...
       '$\phi=4\%$',...
       '$\phi=6\%$',...
       '$\phi=8\%$',...
       '$\phi=10\%$',...
       '$\phi=15\%$',...
       '$\phi=20\%$',...
       '$\phi=25\%$',...
       '$\phi=30\%$',...
       'Location','SouthWest')
set(lgd,'FontSize',10);
xlim([10^-2.5 10^0])
ylim([10^-2 100])
xlabel('$\omega \sqrt{D_p/g}$')
ylabel('$E/[R_0\sqrt{D_p/g}]$')
text(0.5728,0.6014,'$\frac{0.2}{\omega_*^{1.25}}$','FontSize',20)
text(0.1656,10.01,'$\frac{0.05}{\omega_*^{2.75}}$','FontSize',20)

figure(27)
x1 = linspace(10^-2.5,10^0,50);
y1 = 0.8./(x1.^0.6);
y2 = 0.15./(x1.^3);
loglog(Fig12_Ga210_CaseA(:,16),Fig12_Ga210_CaseA(:,18), ...
       Fig12_Ga210_CaseB(:,16),Fig12_Ga210_CaseB(:,18), ...
       Fig12_Ga210_CaseC(:,16),Fig12_Ga210_CaseC(:,18),'--', ...
       Fig12_Ga210_CaseD(:,16),Fig12_Ga210_CaseD(:,18),'--', ...
       Fig12_Ga210_CaseE(:,16),Fig12_Ga210_CaseE(:,18),'--', ...
       Fig12_Ga210_CaseF(:,16),Fig12_Ga210_CaseF(:,18),'--', ...
       x1,y1,'--k', ...
       x1,y2,'--k', 'LineWidth',1.5)
lgd = legend('$\phi=2\%$',...
       '$\phi=6\%$',...
       '$\phi=10\%$',...
       '$\phi=20\%$',...
       '$\phi=25\%$',...
       '$\phi=30\%$',...
       'Location','SouthWest')
set(lgd,'FontSize',10);
xlim([10^-2.5 10^0])
ylim([10^-2 100])
xlabel('$\omega \sqrt{D_p/g}$')
ylabel('$E/[R_0\sqrt{D_p/g}]$')
text(0.6042,1.582,'$\frac{0.8}{\omega_*^{0.6}}$','FontSize',20)
text(0.3383,5.018,'$\frac{0.15}{\omega_*^3}$','FontSize',20)

figure(28)
x1 = linspace(10^-2.5,10^0,50);
y1 = 0.2./(x1.^1.25);
y2 = 0.05./(x1.^2.75);
loglog(Fig12_Ga210_CaseA(:,6),Fig12_Ga210_CaseA(:,8), ...
       Fig12_Ga210_CaseB(:,6),Fig12_Ga210_CaseB(:,8), ...
       Fig12_Ga210_CaseC(:,6),Fig12_Ga210_CaseC(:,8),'--', ...
       Fig12_Ga210_CaseD(:,6),Fig12_Ga210_CaseD(:,8),'--', ...
       Fig12_Ga210_CaseE(:,6),Fig12_Ga210_CaseE(:,8),'--', ...
       Fig12_Ga210_CaseF(:,6),Fig12_Ga210_CaseF(:,8),'--', ...
       x1,y1,'--k', ...
       x1,y2,'--k', 'LineWidth',1.5)
lgd = legend('$\phi=2\%$',...
       '$\phi=6\%$',...
       '$\phi=10\%$',...
       '$\phi=20\%$',...
       '$\phi=25\%$',...
       '$\phi=30\%$',...
       'Location','SouthWest')
set(lgd,'FontSize',10);
xlim([10^-2.5 10^0])
ylim([10^-2 100])
xlabel('$\omega \sqrt{D_p/g}$')
ylabel('$E/[R_0\sqrt{D_p/g}]$')
text(0.5728,0.6014,'$\frac{0.2}{\omega_*^{1.25}}$','FontSize',20)
text(0.1656,10.01,'$\frac{0.05}{\omega_*^{2.75}}$','FontSize',20)

%
% Fig. 13a and Fig. 13b
%
figure(29)
hold on
% Dummy for legend
plot(Fig13a_Ga144_MF(:,1),Fig13a_Ga144_MF(:,5)./Fig13a_Ga144_MF(:,6),'-o','MarkerSize',8.0,'MarkerFaceColor','white' ,'MarkerEdgeColor','k','color','k' )
plot(Fig13a_Ga178_MF(:,1),Fig13a_Ga178_MF(:,5)./Fig13a_Ga178_MF(:,6),'-s','MarkerSize',8.0,'MarkerFaceColor','white','MarkerEdgeColor','k','color','k' )
plot(Fig13a_Ga210_MF(:,1),Fig13a_Ga210_MF(:,5)./Fig13a_Ga210_MF(:,6),'-^','MarkerSize',8.0,'MarkerFaceColor','white','MarkerEdgeColor','k','color','k')
% Data
plot(Fig13a_Ga144_MF(:,1),Fig13a_Ga144_MF(:,5)./Fig13a_Ga144_MF(:,6),'-o','MarkerSize',8.0,'MarkerFaceColor','red' ,'MarkerEdgeColor','k','color','k' )
plot(Fig13a_Ga178_MF(:,1),Fig13a_Ga178_MF(:,5)./Fig13a_Ga178_MF(:,6),'-s','MarkerSize',8.0,'MarkerFaceColor','red','MarkerEdgeColor','k','color','k' )
plot(Fig13a_Ga210_MF(:,1),Fig13a_Ga210_MF(:,5)./Fig13a_Ga210_MF(:,6),'-^','MarkerSize',8.0,'MarkerFaceColor','red','MarkerEdgeColor','k','color','k')
plot(Fig13a_Ga144_MF(:,1),Fig13a_Ga144_MF(:,7)./Fig13a_Ga144_MF(:,6),'-o','MarkerSize',8.0,'MarkerFaceColor','blue' ,'MarkerEdgeColor','k','color','k' )
plot(Fig13a_Ga178_MF(:,1),Fig13a_Ga178_MF(:,7)./Fig13a_Ga178_MF(:,6),'-s','MarkerSize',8.0,'MarkerFaceColor','blue','MarkerEdgeColor','k','color','k' )
plot(Fig13a_Ga210_MF(:,1),Fig13a_Ga210_MF(:,7)./Fig13a_Ga210_MF(:,6),'-^','MarkerSize',8.0,'MarkerFaceColor','blue','MarkerEdgeColor','k','color','k')
xlabel('$\phi$')
ylabel('$\overline{F}/\overline{F}_{ng}$')
legend('$Ga=144$','$Ga=178$','$Ga=210$','Location','NorthWest')

figure(30)
hold on
plot(Fig13b_Ga144_RF(:,1),Fig13b_Ga144_RF(:,2),'-o','MarkerSize',8.0,'MarkerFaceColor','red' ,'MarkerEdgeColor','k','color','k' )
plot(Fig13b_Ga178_RF(:,1),Fig13b_Ga178_RF(:,2),'-s','MarkerSize',8.0,'MarkerFaceColor','blue','MarkerEdgeColor','k','color','k' )
plot(Fig13b_Ga210_RF(:,1),Fig13b_Ga210_RF(:,2),'-^','MarkerSize',8.0,'MarkerFaceColor','green','MarkerEdgeColor','k','color','k')
xlabel('$\phi$')
ylabel('$N_{c}/N_p$')
legend('$Ga=144$','$Ga=178$','$Ga=210$','Location','NorthWest')

%
% Fig. 15a and Fig. 15b
%
figure(31)
hold on
plot(Fig15a_Kynch_Ga144(:,1),Fig15a_Kynch_Ga144(:,2),'-+k')
plot(Fig15a_Ga144(:,1),Fig15a_Ga144(:,2),'o','MarkerSize',8.0,'MarkerFaceColor','red' ,'MarkerEdgeColor','k','color','k')
plot(Fig15a_Kynch_Ga178(:,1),Fig15a_Kynch_Ga178(:,2),'-xk')
plot(Fig15a_Ga178(:,1),Fig15a_Ga178(:,2),'s','MarkerSize',8.0,'MarkerFaceColor','blue','MarkerEdgeColor','k','color','k')
plot(Fig15a_Kynch_Ga210(:,1),Fig15a_Kynch_Ga210(:,2),'-ok')
plot(Fig15a_Ga210(:,1),Fig15a_Ga210(:,2),'^','MarkerSize',8.0,'MarkerFaceColor','green','MarkerEdgeColor','k','color','k')
plot([0. 0.4],[0. 0.],'--k')
xlim([0 0.4])
xlabel('$\phi$')
ylabel('$V_{KW}/V_S$')
legend('Ga 144 Kynch Theory', 'Ga 144 DNS', 'Ga 178 Kynch Theory', 'Ga 178 DNS','Ga 210 Kynch Theory','Ga 210 DNS','Location','SouthWest')

figure(32)
hold on
plot(Fig15b_Ga144(:,1),Fig15b_Ga144(:,2),'-o','MarkerSize',8.0,'MarkerFaceColor','red'  ,'MarkerEdgeColor','k','color','k')
plot(Fig15b_Ga178(:,1),Fig15b_Ga178(:,2),'-s','MarkerSize',8.0,'MarkerFaceColor','blue' ,'MarkerEdgeColor','k','color','k')
plot(Fig15b_Ga210(:,1),Fig15b_Ga210(:,2),'-^','MarkerSize',8.0,'MarkerFaceColor','green','MarkerEdgeColor','k','color','k')
ylabel('$\lambda_{KW}/D_p$')
xlabel('$\phi$')
legend('Ga 144','Ga 178','Ga 210','Location','NorthEast')

%
% Fig. 16 a- c
%
figure(33)
hold on
plot(Fig16a_peakUWspectra(:,1),Fig16a_peakUWspectra(:,2),'-o','LineWidth',1.5)
plot(Fig16a_peakVspectra(:,1),Fig16a_peakVspectra(:,2),'-+','LineWidth',1.5)
plot(Fig16a_KWFreq(:,1),Fig16a_KWFreq(:,2),'-x','LineWidth',1.5)
xlabel('$\phi$')
ylabel('$\omega\sqrt{D_p/g}$')
ylim([0 0.4])
legend('peak u/w spectrum','peak v spectrum','peak uv spectrum','KW wave freq')

figure(34)
hold on
plot(Fig16b_peakUWspectra(:,1),Fig16b_peakUWspectra(:,2),'-o','LineWidth',1.5)
plot(Fig16b_peakVspectra(:,1),Fig16b_peakVspectra(:,2),'-+','LineWidth',1.5)
plot(Fig16b_KWFreq(:,1),Fig16b_KWFreq(:,2),'-x','LineWidth',1.5)
xlabel('$\phi$')
ylabel('$\omega\sqrt{D_p/g}$')
ylim([0 0.4])
legend('peak u/w spectrum','peak v spectrum','peak uv spectrum','KW wave freq')

figure(35)
hold on
plot(Fig16c_peakUWspectra(:,1),Fig16c_peakUWspectra(:,2),'-o','LineWidth',1.5)
plot(Fig16c_peakVspectra(:,1),Fig16c_peakVspectra(:,2),'-+','LineWidth',1.5)
plot(Fig16c_KWFreq(:,1),Fig16c_KWFreq(:,2),'-x','LineWidth',1.5)
xlabel('$\phi$')
ylabel('$\omega\sqrt{D_p/g}$')
legend('peak u/w spectrum','peak v spectrum','peak uv spectrum','KW wave freq')
ylim([0 0.4])

