import numpy as np
import matplotlib.pyplot as plt

fig, axs = plt.subplots(1,6,figsize=(24, 6.5))

# Filenames
# Change Ga to plot all figures: {144,178,210}
Ga = '178'
datas = ['data/CaseA_Ga'+Ga+'_PCA.txt', \
         'data/CaseB_Ga'+Ga+'_PCA.txt', \
         'data/CaseC_Ga'+Ga+'_PCA.txt', \
         'data/CaseD_Ga'+Ga+'_PCA.txt', \
         'data/CaseE_Ga'+Ga+'_PCA.txt', \
         'data/CaseF_Ga'+Ga+'_PCA.txt']

figlabel = ['2%' , \
            '6%' , \
            '10%', \
            '20%', \
            '25%', \
            '30%']

scale_factor = 1
#my_cmap     = 'coolwarm'
#my_cmap     = 'RdYlGn'
my_cmap     = 'RdYlBu'
#my_fontname = "Liberation Serif"
my_fontname = "FreeSerif"
my_fontsize = 20
my_density  = 1.5
my_streamline_color = 'k'

if (Ga=='144'):
    # Ga 178, 210
    sizeX = 164
    sizeY = 132
else:
    # Ga 144
    sizeX = 242
    sizeY = 194 

#--------------------------------------------------

X   = np.zeros(shape=(sizeX,sizeY))
Y   = np.zeros(shape=(sizeX,sizeY))
Phi = np.zeros(shape=(sizeX,sizeY))
U   = np.zeros(shape=(sizeX,sizeY))
V   = np.zeros(shape=(sizeX,sizeY))

radius = 0.5
circle_color = 'white'
circles = [plt.Circle((0, 0), radius, color=circle_color), \
           plt.Circle((0, 0), radius, color=circle_color), \
           plt.Circle((0, 0), radius, color=circle_color), \
           plt.Circle((0, 0), radius, color=circle_color), \
           plt.Circle((0, 0), radius, color=circle_color), \
           plt.Circle((0, 0), radius, color=circle_color)]

# Separate meshgrid (For Ga 178 & 210)
if (Ga=='178' or Ga=='210'):
    x1    = np.zeros(sizeX)
    x1[0] = -5.020833;
    for i in range (1,sizeX):
        x1[i] = x1[i-1] + 0.041666 
    y1    = np.zeros(sizeY)
    y1[0] = -4.020833;
    for i in range (1,sizeY):
        y1[i] = y1[i-1] + 0.041666
    y1, x1 = np.meshgrid( x1, y1, indexing = 'ij', sparse = False)

#--------------------------------------------------
for index in range(0,6):
    print ('dataset : ',index+1)
    data = np.loadtxt(datas[index])
    for i in range (0,sizeX):
        for j in range (0,sizeY):
            X[i,j]   =  data[i*sizeY + j,0]
            Y[i,j]   =  data[i*sizeY + j,1]
            Phi[i,j] =  data[i*sizeY + j,2]
            U[i,j]   = -data[i*sizeY + j,3]*scale_factor
            V[i,j]   = -data[i*sizeY + j,4]*scale_factor
            if ((X[i,j]**2. + Y[i,j]**2.)**0.5 <= (3.*radius + 0.05)):
                U[i,j] = 0.
                V[i,j] = 0.

    #lw = 2.5*magnitude / magnitude.max()
    #print ('Umin scaled : ',U.min())
    #print ('Umax scaled : ',U.max())
    #print ('Vmin scaled : ',V.min())
    #print ('Vmax scaled : ',V.max())
    #print ('magnitude : ',magnitude.min())
    #print ('magnitude : ',magnitude.max())
    
    # Scale by removing extreme values
    for i in range (0,sizeX):
        for j in range (0,sizeY):
            if((X[i,j]**2. + Y[i,j]**2.)**0.5 <= (1.5*2.*radius + 0.05)):
                if ((abs(U[i,j])**2. + abs(V[i,j])**2.)**0.5 >= 0.75e-3*scale_factor):
                    U[i,j] = 0.0
                    V[i,j] = 0.0
    
    # Re-normalize
    #magnitude = np.sqrt(U**2 + V**2)
    #U = U / magnitude.max()
    #V = V / magnitude.max()

    c2 = axs[index].pcolor(X, Y, Phi, cmap=my_cmap, vmin=0.75, vmax=1.25, rasterized=True)
    if (Ga=='144'):
        skip = (slice(None, None, 4), slice(None, None, 4))
        c1 = axs[index].quiver(X[skip], Y[skip], U[skip], V[skip], headwidth=14, headlength=12, headaxislength=12, scale_units='xy', scale=0.0011)
    else:
        skip = (slice(None, None, 6), slice(None, None, 6))
        c1 = axs[index].quiver(x1[skip], y1[skip], U[skip], V[skip], headwidth=14, headlength=12, headaxislength=12, scale_units='xy', scale=0.0013)

    if (index==0):
        #axs[0].quiverkey(c1, X=3.5, Y=1.20, U=1,label='$u_{p,max}$', labelpos='E')
        q1 = axs[0].quiverkey(c1, X=0.785, Y=0.045, U=0.001*scale_factor,label='', labelpos='E', coordinates='figure')
    axs[index].set_xlim(0.0, 4.0)
    axs[index].set_ylim(-5.0, 5.0)
    axs[index].set_xticks(np.arange(0, 5, 2))
    axs[index].set_yticks(np.arange(-5, 6, 1))
    axs[index].set_xticklabels([0, 2, 4], fontsize=15)
    axs[index].set_yticklabels([-5,-4,-4,-2,-1,0,1,2,3,4,5], fontsize=15)
    axs[index].set_aspect(1.)
    axs[index].set_xlabel("X/Dp", fontname=my_fontname, fontsize=my_fontsize)
    axs[index].set_title(figlabel[index], fontname=my_fontname, fontsize=my_fontsize)
    axs[index].add_artist(circles[index])

axs[0].set_ylabel("Y/Dp", fontname=my_fontname, fontsize=my_fontsize)
cbar = fig.colorbar(c2, ax=axs, ticks=[0.75, 1.0, 1.25])
cbar.ax.set_yticklabels(['< 0.75', '1', '> 1.25'], fontname=my_fontname, fontsize=my_fontsize)  # vertically oriented colorbar
plt.text(6.2, -6.2,'$0.001$' , fontsize=my_fontsize)
#--------------------------------------------------
if (Ga=='144'):
    plt.savefig("Fig3a_1e-3_15Apr2023_v3.eps", facecolor='w',bbox_inches="tight")
    plt.savefig("Fig3a_1e-3_15Apr2023_v3.pdf", facecolor='w',bbox_inches="tight")
elif (Ga=='178'):
    plt.savefig("Fig3b_1e-3_15Apr2023_v3.eps", facecolor='w',bbox_inches="tight")
    plt.savefig("Fig3b_1e-3_15Apr2023_v3.pdf", facecolor='w',bbox_inches="tight")
else:
    plt.savefig("Fig3c_1e-3_15Apr2023_v3.eps", facecolor='w',bbox_inches="tight")
    plt.savefig("Fig3c_1e-3_15Apr2023_v3.pdf", facecolor='w',bbox_inches="tight")
plt.show()

