import numpy as np
import matplotlib.pyplot as plt


# Filenames
# Change Ga to plot all figures: {144,178,210}
Ga = '178'
if (Ga == '210'):
    slope_m = -0.006884
    slope_c = -296.342881515033e-003
    slope_x0 = 400.
    slope_y0 = 20.
    slope_x20 = 400.
    slope_y20 = 20.
elif (Ga == '178'):
    slope_m =  0.02214
    slope_c = -285.068043839025e-003
    slope_x0 = 400.
    slope_y0 = 25.
    slope_x20 = 400.
    slope_y20 = 20.
else:
    slope_m =  0.04271
    slope_c = -0.26328951169856607
    slope_x0 = 400.
    slope_y0 = 20.
    slope_x20 = 400.
    slope_y20 = 20.

slope_x = np.arange(100,800,100)
slope_y = slope_m*slope_x + (slope_y0 - slope_m*slope_x0);
slope_y2 = slope_c*slope_x + (slope_y20 - slope_c*slope_x20);

datas = ['Ga'+Ga+'_Vq.txt', \
         'Ga'+Ga+'_Xp.txt', \
         'Ga'+Ga+'_Tp.txt']

#my_cmap     = 'coolwarm'
my_cmap     = 'RdBu'
#my_cmap     = 'RdYlBu'
#my_cmap     = 'RdYlGn'

#my_fontname = "Liberation Serif"
#my_fontname = "Times"
my_fontname = "FreeSerif"
my_fontsize = 20

sizeX1 = 500 
sizeY1 = 961

#--------------------------------------------------
# Initialize variables

R88= np.zeros(shape=(sizeX1,sizeY1))
Z  = np.zeros(shape=(sizeY1))
T  = np.zeros(shape=(sizeX1))

#--------------------------------------------------
# Load the data to variables

data = np.loadtxt(datas[0])
for i in range(0,sizeX1):
    for j in range(0,sizeY1):
        R88[i,j] = data[i*sizeY1 + j]

data = np.loadtxt(datas[1])
Z = data

data = np.loadtxt(datas[2])
T = data
TT, ZZ = np.meshgrid(T, Z, sparse=False)

#--------------------------------------------------
# Plot the data 
fig, ax = plt.subplots(figsize=(14, 5.5))
c2 = plt.pcolor(TT, ZZ, R88, cmap=my_cmap, vmin=0.75, vmax=1.25, rasterized=True)
plt.plot(slope_x,slope_y,linewidth=4,color='black')
plt.plot(slope_x,slope_y2,linewidth=4,color='black',linestyle='dashed')
ax.set_aspect(4.)
ax.set_xlim(100, 700)
ax.set_ylim(0, 50)
ax.set_xticks(np.arange(100, 800, 100))
ax.set_yticks(np.arange(0,60,10))
ax.set_xticklabels([100, 200, 300, 400, 500, 600, 700], fontsize=15)
ax.set_yticklabels([0,10,20,30,40,50], fontsize=15)
ax.set_xlabel("$t$/$\sqrt{D_p/g}$", fontname=my_fontname, fontsize=my_fontsize)
ax.set_ylabel("Y/$D_p$", fontname=my_fontname, fontsize=my_fontsize)
cbar = plt.colorbar(c2,fraction=0.016, pad=0.04, ax=ax, ticks=[0.75, 1.0, 1.25])
cbar.ax.set_yticklabels(['0.75','1.0','1.25'], fontname=my_fontname, fontsize=my_fontsize) # vertically oriented colorbar

#--------------------------------------------------
#plt.savefig("Fig14e.eps", facecolor='w',bbox_inches="tight")
#plt.savefig("Fig14e.pdf", facecolor='w',bbox_inches="tight")
plt.show()
