import numpy as np
import matplotlib.pyplot as plt


# Filenames
# Change Ga to plot all figures: {144,178,210}
Ga = '210'
if (Ga == '210'):
    slope_m = -0.006884
    slope_c = -296.342881515033e-003
elif (Ga == '178'):
    slope_m =  0.02214
    slope_c = -285.068043839025e-003
else:
    slope_m =  0.04271
    slope_c = -0.26328951169856607

slope_x0 = 0.
slope_y0 = 0.
slope_x = np.arange(-300,400,100)
slope_y = slope_m*slope_x + (slope_y0 - slope_m*slope_x0);

datas = ['Ga'+Ga+'_R88.txt', \
         'Ga'+Ga+'_X.txt', \
         'Ga'+Ga+'_T.txt', \
         'Ga'+Ga+'_Vq.txt', \
         'Ga'+Ga+'_Xp.txt', \
         'Ga'+Ga+'_Tp.txt']

my_cmap     = 'coolwarm'
#my_cmap     = 'RdBu'
#my_cmap     = 'RdYlBu'
#my_cmap     = 'RdYlGn'

#my_fontname = "Liberation Serif"
#my_fontname = "Times"
my_fontname = "FreeSerif"
my_fontsize = 20

sizeX1 = 1001 
sizeY1 = 2001

sizeX2 = 500 
sizeY2 = 961

#--------------------------------------------------
# Initialize variables

R88 = np.zeros(shape=(sizeX1,sizeY1))
Z   = np.zeros(shape=(sizeY1))
T   = np.zeros(shape=(sizeX1))
Vp  = np.zeros(shape=(sizeX2,sizeY2))
Zp  = np.zeros(shape=(sizeY2))
Tp  = np.zeros(shape=(sizeX2))

#--------------------------------------------------
# Load the data to variables

data = np.loadtxt(datas[0])
for i in range(0,sizeX1):
    for j in range(0,sizeY1):
        R88[i,j] = data[i*sizeY1 + j]

data = np.loadtxt(datas[1])
Z = data

data = np.loadtxt(datas[2])
T = data
TT, ZZ = np.meshgrid(T, Z, sparse=False)

#--------------------------------------------------
# Plot the data 
fig, ax = plt.subplots(figsize=(14, 5.5))
c2 = plt.pcolor(TT, ZZ, R88, cmap=my_cmap, vmin=-1., vmax=1., rasterized=True)
plt.plot(slope_x,slope_y,linewidth=4,color='black')
ax.set_aspect(4.)
ax.set_xlim(-300, 300)
ax.set_ylim(-25, 25)
ax.set_xticks(np.arange(-300, 400, 100))
ax.set_yticks(np.arange(-25,30,10))
ax.set_xticklabels([-300, -200, -100, 0, 100, 200, 300], fontsize=15)
ax.set_yticklabels([-25,-15,-5,5,15,25], fontsize=15)
ax.set_xlabel("$\Delta t$/$\sqrt{D_p/g}$", fontname=my_fontname, fontsize=my_fontsize)
ax.set_ylabel("$\Delta Y$/$D_p$", fontname=my_fontname, fontsize=my_fontsize)
cbar = plt.colorbar(c2,fraction=0.016, pad=0.04, ax=ax, ticks=[-1, -0.5, 0.0, 0.5, 1.])
cbar.ax.set_yticklabels(['-1','-0.5','0','0.5', '1'], fontname=my_fontname, fontsize=my_fontsize) # vertically oriented colorbar

#--------------------------------------------------
#plt.savefig("Fig14f.eps", facecolor='w',bbox_inches="tight")
#plt.savefig("Fig14f.pdf", facecolor='w',bbox_inches="tight")
plt.show()
