import numpy as np
import matplotlib.pyplot as plt

fig, axs = plt.subplots(1,6,figsize=(24, 6.5))

# Filenames
# Change Ga to plot all figures: {144,178,210}
Ga = '144'
datas = ['CaseA_Ga'+Ga+'_AVG.txt', \
         'CaseB_Ga'+Ga+'_AVG.txt', \
         'CaseC_Ga'+Ga+'_AVG.txt', \
         'CaseD_Ga'+Ga+'_AVG.txt', \
         'CaseE_Ga'+Ga+'_AVG.txt', \
         'CaseF_Ga'+Ga+'_AVG.txt']

figlabel = ['2%' , \
            '6%' , \
            '10%', \
            '20%', \
            '25%', \
            '30%']

#my_cmap     = 'coolwarm'
#my_cmap     = 'RdBu'
my_cmap     = 'RdYlBu'
#my_cmap     = 'RdYlGn'

#my_fontname = "Liberation Serif"
#my_fontname = "Times"
my_fontname = "FreeSerif"
my_fontsize = 20

my_density  = 1.5
my_streamline_color = 'k'
#circle_color = 'aquamarine'
#circle_color = 'palegreen'
circle_color = 'white'
my_contourcolor = 'black'
levels = np.arange(0., 1., 0.2)

# Ga 178, 210
if(Ga=='178' or Ga=='210'):
    sizeX = 193 
    sizeY = 74
else:
# Ga 144
    sizeX = 130 
    sizeY = 49

#--------------------------------------------------

X   = np.zeros(shape=(sizeX,sizeY))
Y   = np.zeros(shape=(sizeX,sizeY))
Phi = np.zeros(shape=(sizeX,sizeY))
U   = np.zeros(shape=(sizeX,sizeY))
V   = np.zeros(shape=(sizeX,sizeY))

radius = 0.52
circles = [plt.Circle((0, 0), radius, color=circle_color), \
           plt.Circle((0, 0), radius, color=circle_color), \
           plt.Circle((0, 0), radius, color=circle_color), \
           plt.Circle((0, 0), radius, color=circle_color), \
           plt.Circle((0, 0), radius, color=circle_color), \
           plt.Circle((0, 0), radius, color=circle_color)]

#--------------------------------------------------
extra = 0.
for index in range(0,6):
    if (Ga == '210'):
        if(index==0 or index==1):
            extra = 0.
        else:
            extra = +25.

    print ('dataset : ',index+1)
    data = np.loadtxt(datas[index])
    for i in range (0,sizeX):
        for j in range (0,sizeY):
            X[i,j]   =  data[i*sizeY + j,0]-12.5
            Y[i,j]   =  data[i*sizeY + j,1]-50.0+extra
            Phi[i,j] =  data[i*sizeY + j,2]
    c1 = axs[index].contour(X, Y, Phi, levels, colors=my_contourcolor)
    c2 = axs[index].pcolor(X, Y, Phi, cmap=my_cmap, vmin=0., vmax=1., rasterized=True)

    axs[index].set_xlim(-1.5, 1.5)
    axs[index].set_ylim(-2.0, 6.0)
    axs[index].set_xticks(np.arange(-1.5, 2.5, 1.5))
    axs[index].set_yticks(np.arange(-2, 7, 1))
    axs[index].set_xticklabels([-1.5, 0, 1.5], fontsize=15)
    axs[index].set_yticklabels([-2,-1,0,1,2,3,4,5,6], fontsize=15)
    axs[index].set_aspect(1.)
    axs[index].set_xlabel("X/Dp", fontname=my_fontname, fontsize=my_fontsize)
    axs[index].set_title(figlabel[index], fontname=my_fontname, fontsize=my_fontsize)
    axs[index].add_artist(circles[index])

axs[0].set_ylabel("Y/Dp", fontname=my_fontname, fontsize=my_fontsize)
cbar = fig.colorbar(c2, ax=axs, ticks=[0., 0.5, 1.])
cbar.ax.set_yticklabels(['0', '0.5', '1'], fontname=my_fontname, fontsize=my_fontsize) # vertically oriented colorbar

#--------------------------------------------------
#plt.savefig("Fig4c.eps", facecolor='w',bbox_inches="tight")
#plt.savefig("Fig4c.pdf", facecolor='w',bbox_inches="tight")
plt.show()
