% Author: Costanza Culmone
% Comparison of two cable configurations in 3D printed steerable instruments for Minimally Invasive Surgey

%% Load data

clear all, close all, clc

for i = 1:12
    
    name = ['maxsub_',num2str(i)];

    load (name);
    
end

%% organize data in sessions
% each session includes 12 subjects for 12 runs together parallel and multi as a start. 

session1=[];
session2=[];
session3=[];
session4=[];

for t=1:12 
    subject=eval(['maxsub_',num2str(t)]);
    session1= [session1 subject(:,1)]; 
    session2= [session2 subject(:,2)];
    session3= [session3 subject(:,3)];
    session4= [session4 subject(:,4)];
end

session1GA= session1(:,1:2:end)'; % session 1 parallel (each row a subject) first time parallel
session1GB= session1(:,2:2:end)'; % session 1 multi (each row a subject) first time multi 

Mean1GA= mean(session1GA);
Mean1GB= [mean(session1GB(:,[1:5])) mean(session1GB(2:end,6)) mean(session1GB(:,7:end))];
Std1GA= std(session1GA);
Std1GB= [std(session1GB(:,[1:5])) std(session1GB(2:end,6)) std(session1GB(:,7:end))];

session2GA= session2(:,1:2:end)'; % session 2 multi (each row a subject) first time multi 
session2GB= session2(:,2:2:end)'; % session 2 parallel (each row a subject) first time parallel
Mean2GA= mean(session2GA);
Mean2GB= mean(session2GB);
Std2GA= std(session2GA);
Sstd2GB= std(session2GB);

session3GA= session3(:,1:2:end)'; % session 3 parallel (each row a subject) second time parallel
session3GB= session3(:,2:2:end)'; % session 3 multi (each row a subject) second time multi
Mean3GA= mean(session3GA);
Mean3GB= mean(session3GB);
Std3GA= std(session3GA);
Std3GB= std(session3GB);

session4GA= session4(:,1:2:end)'; % session 4 multi (each row a subject) second time multi 
session4GB= session4(:,2:2:end)'; % session 4 parallel (each row a subject) second time parallel
Mean4GA= mean(session4GA);
Mean4GB= mean(session4GB);
Std4GA= std(session4GA);
Std4GB= std(session4GB);


%% Figure 7
% boxplot instruments considering all runs per participant

firsttimeP= [session1GA; session2GB]; %each row is the first session of each subject for the parallel for 12 runs (columns)
firsttimeM= [session1GB; session2GA];
 
MfirsttimeP= mean(firsttimeP);
MfirsttimeM= [mean(firsttimeM(:,[1:5])) mean(firsttimeM(2:end,6)) mean(firsttimeM(:,7:end))];
 
figure, boxchart(firsttimeP,'BoxFaceColor',[0 0.4 0.2],'MarkerColor',[0 0.4 0.2],'MarkerStyle','+')
hold on 
boxchart(firsttimeM,'BoxFaceColor',[0.2 0.5 0.9],'MarkerColor',[0.2 0.5 0.9],'MarkerStyle','+')
hold on, plot(MfirsttimeP, 'Linewidth', 2, 'Color', [0 0.6 0.2]) 
hold on, plot(MfirsttimeM, 'Linewidth', 2, 'Color', [0.2 0.4 1])
ylim([0 350])
xlabel('Runs')
ylabel('Time (s)')
 
secondtimeP= [session3GA; session4GB];
secondtimeM= [session3GB; session4GA];
MsecondtimeP= mean(secondtimeP);
MsecondtimeM= mean(secondtimeM);
standsecondP= std(secondtimeP);
standsecondM= std(secondtimeM);

figure, boxchart(secondtimeP,'BoxFaceColor',[0 0.4 0.2],'MarkerColor',[0 0.4 0.2],'MarkerStyle','+')
hold on 
boxchart(secondtimeM,'BoxFaceColor',[0.2 0.5 0.9],'MarkerColor',[0.2 0.5 0.9],'MarkerStyle','+')
hold on, plot(MsecondtimeP, 'Linewidth', 2, 'Color', [0 0.6 0.2]) 
hold on, plot(MsecondtimeM, 'Linewidth', 2, 'Color', [0.2 0.4 1])
ylim([0 350])
xlabel('Runs')
ylabel('Time (s)')

%% Figure 8
% Plot per configuration to compare the instruments over the same trial

figure, boxchart(session1GA,'BoxFaceColor',[1 0.4 0],'MarkerColor',[1 0.4 0],'MarkerStyle','+')
hold on 
boxchart(session2GB,'BoxFaceColor',[0.6 0.2 1],'MarkerColor',[0.6 0.2 1],'MarkerStyle','+') 
hold on, plot(Mean1GA, 'Linewidth', 2, 'Color', [1 0.4 0]) 
hold on, plot(Mean2GB, 'Linewidth', 2, 'Color', [0.6 0.2 1])
ylim([0 450])
xlabel('Runs')
ylabel('Time (s)')

figure, boxchart(session2GA,'BoxFaceColor',[1 0.4 0],'MarkerColor',[1 0.4 0],'MarkerStyle','+')
hold on 
boxchart(session1GB,'BoxFaceColor',[0.6 0.2 1],'MarkerColor',[0.6 0.2 1],'MarkerStyle','+') 
hold on, plot(Mean2GA, 'Linewidth', 2, 'Color', [1 0.4 0]) 
hold on, plot(Mean1GB, 'Linewidth', 2, 'Color', [0.6 0.2 1])
ylim([0 450])
xlabel('Runs')
ylabel('Time (s)')

figure, boxchart(session3GA,'BoxFaceColor',[1 0.4 0],'MarkerColor',[1 0.4 0],'MarkerStyle','+')
hold on
boxchart(session4GB,'BoxFaceColor',[0.6 0.2 1],'MarkerColor',[0.6 0.2 1],'MarkerStyle','+')
hold on, plot(Mean3GA, 'Linewidth', 2, 'Color', [1 0.4 0]) 
hold on, plot(Mean4GB, 'Linewidth', 2, 'Color', [0.6 0.2 1])
ylim([0 450])
xlabel('Runs')
ylabel('Time (s)')

figure, boxchart(session4GA,'BoxFaceColor',[1 0.4 0],'MarkerColor',[1 0.4 0],'MarkerStyle','+')
hold on 
boxchart(session3GB,'BoxFaceColor',[0.6 0.2 1],'MarkerColor',[0.6 0.2 1],'MarkerStyle','+')
hold on, plot(Mean4GA, 'Linewidth', 2, 'Color', [1 0.4 0]) 
hold on, plot(Mean3GB, 'Linewidth', 2, 'Color', [0.6 0.2 1])
ylim([0 450])
xlabel('Runs')
ylabel('Time (s)')

%% Mann Whitney U test (Wilcoxon runk sum): comparison between independent groups: P1A-P1B  and M1B-M1A (first run)
% test for non-parametric data
[pAB1,hAB1,statsAB1] = ranksum(session1GA(:,1), session2GB (:,1), 'Alpha',0.05)
[pAB2,hAB2,statsAB2] = ranksum(session2GA(:,1), session1GB (:,1), 'Alpha',0.05) 
