% Author: Costanza Culmone 
% Comparison of two cable configurations in 3D printed steerable instruments for Minimally Invasive Surgey

%% Task performance time for the two cable configurations Tp1 Tp2 | Tm1 Tm2

clear all, close all, clc

% Load data
for i = 1:12
    
    name1 = ['sub_',num2str(i)];        % subject name
    name2 = ['meantime_',name1,'.mat']; % import the mean for each trial of each subject (1x4)
    name3 = ['maxsub_',num2str(i)];     % max time for each run for each session in the 4 trials (matrices of 12x4) 
   
    load(name2);
    load (name3);
    
end

%% boxplot for the overall

allvec1=[]; % parallel configuration as first trial1 trial2
for t=1:2:12
        meantime1= eval(['meantime_sub_',num2str(t)]);
        calc_curr=eval(['maxsub_',num2str(t)]);
        meanpp1(t,:)=meantime1([1 3]);
        allvec1= [allvec1; calc_curr(:,[1 3])]; % trial 1 and 2 parallel, all runs for all te 6 subjects that start with parallel
end

allvec2=[]; %multi-actuation configuration as second trial1 trail2
for t=1:2:12
        meantime2= eval(['meantime_sub_',num2str(t)]);
        calc_curr=eval(['maxsub_',num2str(t)]);
        meanpp1(t,:)=meantime2([2 4]);
        allvec2= [allvec2; calc_curr(:,[2 4])];
end

allvec3=[]; %multi-actuation configuration as first trial1 trail2
for t=2:2:12
        meantime3= eval(['meantime_sub_',num2str(t)]);
        calc_curr=eval(['maxsub_',num2str(t)]);
        meanpp1(t,:)=meantime3([1 3]);
        allvec3= [allvec3; calc_curr(:,[1 3])];
end

allvec4=[]; %parallel configuration as first trial1 trial2
for t=2:2:12
        meantime4= eval(['meantime_sub_',num2str(t)]);
        calc_curr=eval(['maxsub_',num2str(t)]);
        meanpp1(t,:)=meantime4([2 4]);
        allvec4= [allvec4; calc_curr(:,[2 4])];
end

GP= [allvec1; allvec4]; % all first and second trial of parallel configuration for the 12 subjects (144x2) 
GM= [allvec2; allvec3]; % all first and second trial of multi-actuation configuration for the 12 subjects (144x2) 

%% Mann Whitney U test (Wilcoxon runk sum): comparison between independent groups: P1-M1 and P2-M2
% test for non-parametric data
[pPM1,hPM1,statsPM1] = ranksum(GP(:,1),GM (:,1), 'Alpha',0.01)
[pPM2,hPM2,statsPM2] = ranksum(GP(:,2),GM (:,2), 'Alpha',0.01) 

%% Wilcoxon signed rank test for paired groups (dependent): comparison between P1-P2 and M1-M2
% test for non-parametric data

[pP12,hP12,statsP12] = signrank(GP(:,1),GP(:,2), 'Alpha',0.01) 
[pM12,hM12,statsM12] = signrank(GM(:,1),GM(:,2), 'Alpha',0.01) 

%% Figure 6
GP1M1= [GP(:,1), GM(:,1)];
GP2M2= [GP(:,2), GM(:,2)];  
data= {GP1M1, GP2M2};

figure, boxplotGroup(data, 'PrimaryLabels', {'Trial 1' 'Trial 2'},'SecondaryLabels',{'Parallel', 'Multi'},'GroupLines', true)