# Article data

In this repository, you can find the data for the paper

	Reducing hardware requirements for entanglement distribution via joint hardware-protocol optimization

	Adrià Labay-Mora, Francisco Ferreira da Silva and Stephanie Wehner

## Organisation

The repository contains two folders named `target_0` and `target_1` corresponding to the two pairs of target values analysed in the paper:

* `target_0`: $F = 0.8$ and $R = 1\, \mathrm{Hz}$ 
* `target_1`: $F = 0.9$ and $R = 0.1\, \mathrm{Hz}$ 

Inside the two target folders, a new collection of directories contain the best result per distance. The name of the subfolder indicates the total distance between end nodes. 

The best result, located in each of the previous subfolders, contains 3 different kind of files:

* 500 `.npy` files: the name corresponds to the generation of the genetic algorithm (for instance, `42.npy` is the data for the 42nd generation). Opening these files with `numpy` loads a matrix with `120x8` elements. The rows are the `120` individuals for that particular generation. In the columns are the rate, fidelity followed by the optimization parameters.
* `best_result.csv`: NetSquid data output by the `NetSquid-Repchain` code. The file contains information about the final state generated like the elements of the density matrix, the pauli correction needed to recover $| \Psi_+ \rangle$, the amount of times the state is purified between the connected nodes and the most important quantities: fidelity and entanglement generation rate.
* `best_result_params.pkl`: a Python data object with the optimal parameters and the improvement cost. To open the file use:

```python
with open('best_result_params.pkl', 'rb') as f:
...     data = pickle.load(f)

# `data` is a dictionary like

{'T1': 4064653657007.979,
 'T2': 81700600696.16275,
 'alpha': 0.07430870493994694,
 'c': 208189.20694444445,
 'cycle_time': 3500.0,
 'detector_efficiency': 0.719569195024522,
 'distillation_strategy': [('DEJMPS', 2), None, None, None, None],
 'elementary_link_fidelity': 0.9120363517199022,
 'elementary_link_succ_prob': 0.011658488560311164,
 'eps': 0.0,
 'internode_distance': 87.5,
 'k_gates': 47.35004721628777,
 'number_of_nodes': 17,
 'p_loss_length': 0.22,
 'p_q1gate': 2.817746325456394e-05,
 'p_q1init': 0.00012708941710914967,
 'p_q1meas': (0.00021223356463762055, 0.00010585578706368004),
 'p_q2gate': 0.000426576090259978,
 'respect_NV_structure': False,
 'result': {'cost': {'T1': 1.129070478205683,
                     'T2': 81.74097799963306,
                     'detector_efficiency': 16.352648686572206,
                     'k_gates': 236.75023608143886,
                     'state_efficiency': 5.642144331122312,
                     'total': 341.6150775769721},
            'fidelity': 0.9021777370881106,
            'fidelity_unc': 0.0007747828976931037,
            'rate': 1.2987856848113422,
            'rate_unc': 0.019940832611641333},
 'state_efficiency': 0.9852489232500937,
 't_q1gate': 20000.0,
 't_q1init': 310000.0,
 't_q1meas': 3700.0,
 't_q2gate': 500000.0,
 'tot_num_qubits': 10,
 'use_swap_only': False,
 'werner': False}
```

The most important elements are:

- Hardware parameters (`T1`, `p_q1gate`, `cycle_time`): their contribution to the repeater chain is described in the paper. If the hardware parameter is one of the optimisation parameters, its value corresponds to the optimal one found by the GA. Otherwise, its value is the one we fixed in all simulations.
- `distillation_strategy`: list of tuples, each element in the list is the purification protocol used in each nesting level of the `BDCZ` protocol. In the previous example, two rounds of `DEJMPS` are used in the lowest nesting level.
- `result`: contains the hardware cost of the individual parameters as well as the total cost, the fidelity of the final link and the entanglement generation rate. Since the last two quantities are averaged over 100 realisations, the uncertainty of the average done is also included.
