def shape(site, device):
    """
    Define the shape in the honeycomb structure region of the
    device.

    Parameters:
    -----------

    site : Kwant site
    """

    x, y = site.pos
    L = device.dimensions["L_device"]
    return (-L <= x <= L) and (- 1.5 * L <= y <= 1.5 * L)

def leads(site, device, orientation, prefactor):
    """
    Set metallic leads shape.

    Parameters:
    -----------

    site : Kwant site
    """
    x, y = site.pos
    L = device.dimensions["L_device"]
    l = prefactor * device.dimensions["L_lead"]
    if orientation == 'armchair':
        return -l/2 <= y <= l/2
    elif orientation == 'zigzag':
        return -L <= x <= L

def lead_transverse(site, device, position, prefactor):
    x, y = site.pos
    L = prefactor * device.dimensions["L_device"]
    l = device.dimensions["L_lead"]
    if position == 'upper':
        return -l/2 + L * 1.25 / 2 <= y <= l/2 + L * 1.25 / 2
    elif position == 'lower':
        l *= prefactor
        return -l/2 - L * 1.25 / 2 <= y <= l/2 - L * 1.25 / 2