# -*- coding: utf-8 -*-
"""
Created on Sat Jan 28 10:21:22 2023

@author: jinglaaynes
"""
import matplotlib.pyplot as plt
import numpy as np
from scipy.signal import argrelextrema, savgol_filter
from scipy.optimize import curve_fit


font = {'family' : 'DejaVu Sans',
        'weight' : 'normal',
        'size'   : '15'}
plt.rc('font', **font)

def RvsBDifferentVbgPlot1Gate(filename, Vbgrange=1, Binc=0):
    '''
    Plots R vs B curves at different Vbg values

    Parameters
    ----------
    filename : string containing the file name
    Vbgrange : optional, list including the minimal and maximal Vbg to plot 
    Binc : optional, numeric. Only the sign matters. If positive, increasing B
            is selected, otherwise, negative. If zero nothing happens.

    '''
    
    data=np.loadtxt(filename, skiprows = 18)
    B, Vbg, Vdiff, *other = data.T
    Vbgs = np.sort(np.unique(Vbg))
    if Vbgrange!=1:
        filt_range = np.multiply(Vbgs<max(Vbgrange),Vbgs>min(Vbgrange))
        Vbgs = Vbgs[filt_range]
    for i, Vb in enumerate(Vbgs):
        filt = Vbg == Vb
        if Binc!=0:
            B_diff = np.append(np.diff(B),0)
            filt =np.multiply(filt, B_diff*np.sign(Binc)>0)
        Bfilt = B[filt]
        Vdifffilt = Vdiff[filt]
        Vsmooth = savgol_filter(Vdifffilt, 11, 1)
        plt.plot(Bfilt, (Vsmooth)*1E7, '-',label='$V_\mathrm{}={}$ V'.format('{bg}',round(Vb,2)))#-np.average(Vdifffilt)+i*0E-5
    plt.legend()#loc='upper left'
    plt.xlabel('$B$ (T)', fontsize=20)
    plt.ylabel('$R_\mathrm{4p}$ ($\Omega$)', fontsize=20)
    plt.tick_params(direction='in', top=True, right=True)
    # plt.savefig(filename[:19]+'.pdf')
    # print(filename[:19])
    return
#%% M24
filename='M24_BLGhBN14_I02to03_100nA_V31to27_100x.dat'
RvsBDifferentVbgPlot1Gate(filename,Vbgrange=[-5,-0.5],Binc=1)
plt.savefig('SdHOscillationsHoles.pdf')
plt.show()
RvsBDifferentVbgPlot1Gate(filename,Vbgrange=[-0.5,0.5],Binc=1)
plt.show()
#%% M25
filename = 'M25_BLGhBN14_I02to03_100nA_V31to27.dat'
RvsBDifferentVbgPlot1Gate(filename,Binc=1,Vbgrange=[0,4.5])
plt.savefig('SdHOscillationsElec.pdf')
plt.show()
#%% B where R4p is minimal selected manually from the raw data
Bmin3V = [5.21307, 6.33977]
Bmin2V = [4.27554, 5.30788]
Bmin1V = [3.5244,  5.26024]
Bminm4V = [4.91567, 5.48225]
Bminm3V = [(3.96935 + 4.15852)/2, 4.72603]
Bminm2V = [3.02349, 3.78018]
Bminm1V = [2.07856, 3.02442]
Bmin = [Bmin1V, Bmin2V, Bmin3V] # Bminm4V, Bminm3V, Bminm2V, Bminm1V, 
#Bmin = [Bminm3V, Bminm2V, Bminm1V] # Bminm4V, Bminm3V, Bminm2V, Bminm1V, 
diB = np.array([])
for Bvg in Bmin:
    delta = 1/Bvg[0]-1/Bvg[1]
    print(delta)
    diB = np.append(diB, delta)
Vg = [1, 2, 3] # -4, -3, -2, -1
#Vg = [ -3, -2, -1] 
el = 1.602E-19
h = 6.626E-34
eps0 = 8.854E-12
n = 2*2*el/(h*diB)
plt.plot(Vg, n*1E-16, 'o')
lfit = np.polyfit(Vg, n, 1)#[:-3]
pol = np.poly1d(lfit)
poly = lambda Vg, a, b: a*Vg+b
popt, pcov = curve_fit(lambda Vg,a, b: poly(Vg, a, b), Vg, n, p0=[9E+15, 1.9E+15])
errfit = np.sqrt(np.diag(pcov))
Vgfit = np.linspace(-6, 6,500)
#print('a,b={} aerr,berr={}'.format(popt, errfit))
plt.plot(Vgfit, (poly(Vgfit,*popt))*1E-16)
plt.tick_params(direction='in', top=True, right=True)
plt.xlabel('$V_\mathrm{bg}$ (V)', fontsize=20)
plt.ylabel('n ($\\times10^{12}$cm$^{-2}$)', fontsize=20)
plt.xlim([0, 4.5])
plt.ylim([0, 4.5])
gate_cap = popt[0] * el
Vcnp = -popt[1] / popt[0]
gate_cap_err = errfit[0] * el
er = gate_cap*23E-9/eps0
er_er = gate_cap_err*23E-9/eps0
print('C={}\pm{}F/m2 Vcnp={}V \eps_r={}\pm{}'.format(gate_cap, gate_cap_err, Vcnp, er, er_er))
plt.savefig('CbgFromSdH.pdf')