# -*- coding: utf-8 -*-
"""
Created on Sat Jan 28 11:59:15 2023

@author: jinglaaynes
"""
import numpy as np
from scipy import fftpack, fft
from scipy.signal import argrelextrema
import matplotlib.pyplot as plt
font = {'family' : 'DejaVu Sans',
        'weight' : 'normal',
        'size'   : '15'}
plt.rc('font', **font)

def Fourier_transform(Bs, Vs):
    '''
    Fourier transform of Vs where Bs is the independent variable.
    The model uses linspace and np.interp to generate evenly spaced data
    This means that Bs has to be increasing.
    
    Parameters
    ----------
    Bs : TYPE
        DESCRIPTION.
    Vs : TYPE
        DESCRIPTION.

    Returns
    -------
    None.

    '''
    # We oversample the B space to guarantee that the spectra are well reproduced
    # independently of the offsets.
    B_even = np.linspace(0.1, 3, 1000)
    # Interpolate the voltages
    V_even = np.interp(B_even, Bs, Vs)
    plt.plot(B_even, V_even)
    plt.show()
    # Number of sample points
    N = len(B_even)
    # Sample spacing
    T = np.diff(B_even)[0]
    xf = fftpack.fftfreq(N, T)[:N//2]
    VTrans = fft(V_even-np.mean(V_even))[:N//2]
    plt.figure(figsize=(1.5, 0.8))
    plt.plot(xf, np.abs(VTrans)*1E2, '-')
    plt.xlim([0, 10])
    plt.ylim([0, 0.5])
    
    # Find local maxima
    idx = argrelextrema(np.abs(VTrans), np.greater)
    
    first_peaks = (1/xf[idx])
    # Identify FFT peaks with period smaller than 0.25T
    idx2 = first_peaks < 0.25
    plt.plot(xf[idx][idx2][:2], 1E2*np.abs(VTrans[idx][idx2][:2]), 'xr')
    print('Peak positions {}'.format(xf[idx][idx2][:2]))
    plt.tick_params(direction='in',top=True, right=True)
    plt.xlabel('Freq (1/T)', fontsize=20)
    plt.ylabel('abs(FFT)', fontsize=20)
    return
#%% Import data
data = np.loadtxt('C:\\Users\jinglaaynes\OneDrive - Delft University of Technology\Devices\BLGhBN_14\Animal\Analysis\M16_BLGhBN14_I32to18_100nA_V02to30_100x.dat')
#%% Extract magnetic field retrace (data shown in the main manuscript and SI)
Bs = -data[500:1000,0]# + 0.1 # Magnet remanence
print(Bs[0])
# Filter positive field
positive_B = Bs > 0
Bs = Bs[positive_B]
# Extract and filter voltages
Vs = data[500:1000,3][positive_B]
Fourier_transform(Bs[::-1], Vs[::-1])
plt.xticks([0,5,10])
plt.savefig('FourierTransform.pdf')
plt.show()
#plt.plot(Bs, Vs)
print(Bs[0])

#%% Extract magnetic field trace
Bs = -data[:500,0]
# Filter positive field
positive_B = Bs > 0
Bs = Bs[positive_B]
# Extract and filter voltages
Vs = data[:500,3][positive_B]
Fourier_transform(Bs, Vs)
plt.savefig('FourierTransformTrace.pdf')
plt.show()
#plt.plot(Bs, Vs)
print(Bs[0])
