# -*- coding: utf-8 -*-
"""
Created on Wed Jan 25 18:51:02 2023

@author: jinglaaynes
"""
import numpy as np
from scipy.signal import savgol_filter
import matplotlib.pyplot as plt

def read_multiple_files(filename_list, skrows=14):
    for i, f in enumerate(filename_list):
        if i == 0:
            data = np.loadtxt(f, skiprows=skrows)
        else:
            data1 = np.loadtxt(f, skiprows=skrows)
            data = np.vstack((data, data1))
    return data

filename_list = ['M14_BLGhBN14_I32to18_100nA_V02to30_100x.dat',
                 'M16_BLGhBN14_I32to18_100nA_V02to30_100x.dat',
                 'M17_BLGhBN14_I32to18_100nA_V02to30_100x.dat',
                 'M28_BLGhBN14_I32to18_100nA_V02to30_100x.dat']
data = read_multiple_files(filename_list, skrows=14)
B, Vbg, Vtg, Vdiff, Vmean, Tarr = data.T
Vbgs = np.sort(np.unique(np.round(Vbg,2)))
filt_Vbg = np.abs(Vbgs)>1
ind_i_list = []
ind_f_list = []
final_data = np.array([])
for i, Vb in enumerate(Vbgs[filt_Vbg]):
    #plt.show()
    ind_i, ind_f = 0, 0
    filt_Vbgu = np.round(Vbg,2)==Vb
    Vbgu = Vbg[filt_Vbgu]
    Vtgu = Vtg[filt_Vbgu]
    Bu = B[filt_Vbgu]
    Vxu = Vdiff[filt_Vbgu]
    Vmeu = Vmean[filt_Vbgu]
    Tarru = Tarr[filt_Vbgu]
    plt.title(Vb)
    diffs = np.sign(np.diff(savgol_filter(Bu, 11, 1)))
    inds = np.where(np.diff(diffs))
    inds = np.append(inds[0], len(Bu)-1)
    inds = np.append(0, inds)
    #print(inds)
    l = len(inds)
    for j in range(l-1):
        #print('Vbg={} j={}'.format(Vb, j))
        Bslice = diffs[inds[j]+1:inds[j+1]+1]
        #plt.plot(Bslice)
        if (len(Bslice)>250)&(Bslice[0]>0):
            #print(Bslice[0])
            ind_i, ind_f = inds[j], inds[j+1]
            ind_i_list.append(ind_i)
            ind_f_list.append(ind_f)
            #print(ind_i, ind_f)
    f_data = np.vstack((Bu[ind_i:ind_f], Vbgu[ind_i:ind_f], Vtgu[ind_i:ind_f],
                           Vxu[ind_i:ind_f],Vmeu[ind_i:ind_f], Tarru[ind_i:ind_f]))
    if len(final_data)>1: 
        final_data = np.hstack((final_data, f_data))
    else:
        final_data = f_data
    plt.plot(Bu[ind_i:ind_f], Vxu[ind_i:ind_f] * 1E7 + 500 * i, label='Vbg={}'.format(np.round(Vb, 1)))
plt.legend()
# Save to an output file
fname = 'M14M16M17M28_OverviewC1.txt'
np.savetxt(fname, final_data.T, header='B\t Vbg\t Vtg\t V_diff\t V_avg \t T')
# I want a decreasing B-field window which is 500-600 points long
# if len>400 and np.diff()